/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.impl.publisher.AbstractMetadataGenerator;
import org.eclipse.tycho.p2.impl.publisher.DependencyMetadata;
import org.eclipse.tycho.p2.impl.publisher.DownloadStatsAdvice;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.metadata.DependencyMetadataGenerator;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.PublisherOptions;
import org.osgi.framework.BundleException;

public class SourcesBundleDependencyMetadataGenerator
extends AbstractMetadataGenerator
implements DependencyMetadataGenerator {
    private static final String SUFFIX_QUALIFIER = ".qualifier";
    private static final String SUFFIX_SNAPSHOT = "-SNAPSHOT";
    private MavenContext mavenContext;

    public DependencyMetadata generateMetadata(IArtifactFacade artifact, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction, PublisherOptions options) {
        return super.generateMetadata(artifact, environments, new PublisherInfo(), optionalAction, options);
    }

    @Override
    protected List<IPublisherAction> getPublisherActions(IArtifactFacade artifact, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction) {
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        String id = artifact.getArtifactId();
        String version = SourcesBundleDependencyMetadataGenerator.toCanonicalVersion(artifact.getVersion());
        try {
            Hashtable<String, String> manifest = new Hashtable<String, String>();
            ((Dictionary)manifest).put("Manifest-Version", "1.0");
            ((Dictionary)manifest).put("Bundle-ManifestVersion", "2");
            String sourceBundleSymbolicName = String.valueOf(id) + ".source";
            ((Dictionary)manifest).put("Bundle-SymbolicName", sourceBundleSymbolicName);
            ((Dictionary)manifest).put("Bundle-Version", version);
            ((Dictionary)manifest).put("Eclipse-SourceBundle", String.valueOf(id) + ";version=" + version + ";roots:=\".\"");
            StateObjectFactory factory = StateObjectFactory.defaultFactory;
            BundleDescription bundleDescription = factory.createBundleDescription(factory.createState(false), manifest, artifact.getLocation().getAbsolutePath(), this.createId(sourceBundleSymbolicName, version));
            bundleDescription.setUserObject(manifest);
            actions.add((IPublisherAction)new BundlesAction(new BundleDescription[]{bundleDescription}){

                protected void createAdviceFileAdvice(BundleDescription bundleDescription, IPublisherInfo publisherInfo) {
                }
            });
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        return actions;
    }

    @Override
    protected List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade artifact, PublisherOptions options) {
        ArrayList<IPublisherAdvice> advice = new ArrayList<IPublisherAdvice>();
        advice.add((IPublisherAdvice)new MavenPropertiesAdvice(artifact, "sources", this.mavenContext));
        if (options.generateDownloadStatsProperty) {
            advice.add((IPublisherAdvice)new DownloadStatsAdvice());
        }
        return advice;
    }

    private static String toCanonicalVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith(SUFFIX_SNAPSHOT)) {
            return String.valueOf(version.substring(0, version.length() - SUFFIX_SNAPSHOT.length())) + SUFFIX_QUALIFIER;
        }
        return version;
    }

    public long createId(String sourceBundleSymbolicName, String version) {
        return (long)sourceBundleSymbolicName.hashCode() | (long)version.hashCode() << 32;
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }
}

