/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.DependencyResolutionException;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.target.ArtifactMatcher;
import org.eclipse.tycho.p2.target.ArtifactTypeHelper;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;

abstract class TargetPlatformBaseImpl
implements P2TargetPlatform {
    protected final LinkedHashSet<IInstallableUnit> installableUnits;
    private final Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup;
    final Map<IInstallableUnit, IArtifactFacade> mavenArtifactLookup;
    final ExecutionEnvironmentResolutionHints executionEnvironment;
    final IRawArtifactFileProvider artifacts;
    @Deprecated
    private LocalArtifactRepository localArtifactRepository;

    public TargetPlatformBaseImpl(LinkedHashSet<IInstallableUnit> installableUnits, ExecutionEnvironmentResolutionHints executionEnvironment, IRawArtifactFileProvider artifacts, LocalArtifactRepository localArtifactRepository, Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup, Map<IInstallableUnit, IArtifactFacade> mavenArtifactLookup) {
        this.installableUnits = installableUnits;
        this.executionEnvironment = executionEnvironment;
        this.reactorProjectLookup = reactorProjectLookup;
        this.mavenArtifactLookup = mavenArtifactLookup;
        this.artifacts = artifacts;
        this.localArtifactRepository = localArtifactRepository;
    }

    @Override
    public final Set<IInstallableUnit> getInstallableUnits() {
        return this.installableUnits;
    }

    public final ArtifactKey resolveArtifact(String type, String id, String version) throws IllegalArtifactReferenceException, DependencyResolutionException {
        IInstallableUnit resolvedUnit;
        if (version != null && (version.startsWith("[") || version.startsWith("("))) {
            resolvedUnit = this.resolveUnit(type, id, VersionRange.create((String)version));
        } else if (version != null && version.contains("|")) {
            String[] split = version.split("\\|", 2);
            resolvedUnit = this.resolveUnit(type, id, ArtifactMatcher.getVersionRangeFromImport(split[0], split[1]));
        } else {
            resolvedUnit = this.resolveUnit(type, id, ArtifactMatcher.parseAsOSGiVersion(version));
        }
        if ("eclipse-feature".equals(type)) {
            return new DefaultArtifactKey(type, id, resolvedUnit.getVersion().toString());
        }
        return new DefaultArtifactKey(type, resolvedUnit.getId(), resolvedUnit.getVersion().toString());
    }

    @Override
    public final IInstallableUnit resolveUnit(String type, String id, Version version) throws IllegalArtifactReferenceException, DependencyResolutionException {
        VersionRange versionRange = ArtifactMatcher.getVersionRangeFromReference(version);
        return this.resolveUnit(type, id, versionRange);
    }

    @Override
    public IInstallableUnit resolveUnit(String type, String id, VersionRange versionRange) throws IllegalArtifactReferenceException, DependencyResolutionException {
        IInstallableUnit matchingUnit = ArtifactMatcher.resolveReference(type, id, versionRange, this.installableUnits);
        if (matchingUnit == null) {
            String message = String.valueOf(type) + " artifact with ID \"" + id + "\" and version matching \"" + versionRange + "\" was not found in the target platform";
            String candidates = this.installableUnits.stream().sorted(Comparator.comparing(IVersionedId::getId).thenComparing(IVersionedId::getVersion)).filter(iu -> iu.getId().contains(id)).map(iu -> String.valueOf(iu.getId()) + ":" + iu.getVersion()).collect(Collectors.joining(System.lineSeparator()));
            if (!candidates.isBlank()) {
                message = String.valueOf(message) + ", did you probably mean: " + candidates;
            }
            throw new DependencyResolutionException(message);
        }
        return matchingUnit;
    }

    @Override
    public final ExecutionEnvironmentResolutionHints getEEResolutionHints() {
        return this.executionEnvironment;
    }

    @Override
    public final Map<IInstallableUnit, ReactorProjectIdentities> getOriginalReactorProjectMap() {
        return this.reactorProjectLookup;
    }

    @Override
    public final Map<IInstallableUnit, IArtifactFacade> getOriginalMavenArtifactMap() {
        return this.mavenArtifactLookup;
    }

    @Override
    public final File getLocalArtifactFile(IArtifactKey key) {
        return this.artifacts.getArtifactFile(key);
    }

    @Override
    public final void saveLocalMavenRepository() {
        this.localArtifactRepository.save();
    }

    public File getArtifactLocation(ArtifactKey artifact) {
        IArtifactKey p2Artifact = ArtifactTypeHelper.toP2ArtifactKey(artifact);
        if (p2Artifact != null) {
            return this.artifacts.getArtifactFile(p2Artifact);
        }
        return null;
    }

    public boolean isFileAlreadyAvailable(ArtifactKey artifact) {
        IArtifactKey p2Artifact = ArtifactTypeHelper.toP2ArtifactKey(artifact);
        if (p2Artifact != null) {
            return this.artifacts.isFileAlreadyAvailable(p2Artifact);
        }
        return false;
    }
}

