/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.p2.remote.IRepositoryIdManager;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.repository.p2base.artifact.repository.LazyArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.repository.RepositoryArtifactProvider;

public class URITargetDefinitionContent
implements TargetDefinitionContent {
    private final IArtifactRepository artifactRepository;
    private IProvisioningAgent agent;
    private URI location;
    private String id;
    private IMetadataRepository metadataRepository;

    public URITargetDefinitionContent(IProvisioningAgent agent, URI location, String id) {
        this.agent = agent;
        this.location = location;
        this.id = id;
        this.artifactRepository = new LazyArtifactRepository(agent, location, RepositoryArtifactProvider::loadRepository);
    }

    @Override
    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        this.preload((IProgressMonitor)subMonitor.split(100));
        subMonitor.setWorkRemaining(100);
        return this.getMetadataRepository().query(query, (IProgressMonitor)subMonitor.split(100));
    }

    @Override
    public IMetadataRepository getMetadataRepository() {
        this.preload(null);
        return this.metadataRepository;
    }

    public synchronized void preload(IProgressMonitor monitor) {
        if (this.metadataRepository == null) {
            IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
            if (metadataManager == null) {
                throw new TargetDefinitionResolutionException("IMetadataRepositoryManager is null in IProvisioningAgent");
            }
            IRepositoryIdManager repositoryIdManager = (IRepositoryIdManager)this.agent.getService(IRepositoryIdManager.class);
            if (repositoryIdManager != null) {
                repositoryIdManager.addMapping(this.id, this.location);
            }
            try {
                this.metadataRepository = metadataManager.loadRepository(this.location, monitor);
            }
            catch (ProvisionException e) {
                throw new TargetDefinitionResolutionException("Failed to load p2 metadata repository from location " + this.location, (Throwable)e);
            }
        }
    }

    @Override
    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }
}

