/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.AdviceFileParser;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.OptionalResolutionAction;
import org.osgi.framework.Version;

public class BundleDependenciesAction
extends BundlesAction {
    private final OptionalResolutionAction optionalAction;

    public BundleDependenciesAction(File location, OptionalResolutionAction optionalAction) {
        super(new File[]{location});
        this.optionalAction = optionalAction;
    }

    protected void addImportPackageRequirement(List<IRequirement> reqsDeps, ImportPackageSpecification importSpec, ManifestElement[] rawImportPackageHeader) {
        boolean required;
        if (this.optionalAction == OptionalResolutionAction.OPTIONAL) {
            super.addImportPackageRequirement(reqsDeps, importSpec, rawImportPackageHeader);
            return;
        }
        VersionRange versionRange = PublisherHelper.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)importSpec.getVersionRange());
        boolean bl = required = !BundleDependenciesAction.isOptional((ImportPackageSpecification)importSpec) || this.optionalAction == OptionalResolutionAction.REQUIRE;
        if (required) {
            reqsDeps.add(MetadataFactory.createRequirement((String)"java.package", (String)importSpec.getName(), (VersionRange)versionRange, null, (int)1, (int)1, (boolean)true));
        }
    }

    protected void addRequireBundleRequirement(List<IRequirement> reqsDeps, BundleSpecification requiredBundle, ManifestElement[] rawRequireBundleHeader) {
        boolean required;
        if (this.optionalAction == OptionalResolutionAction.OPTIONAL) {
            super.addRequireBundleRequirement(reqsDeps, requiredBundle, rawRequireBundleHeader);
            return;
        }
        VersionRange versionRange = PublisherHelper.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)requiredBundle.getVersionRange());
        boolean bl = required = !requiredBundle.isOptional() || this.optionalAction == OptionalResolutionAction.REQUIRE;
        if (required) {
            reqsDeps.add(MetadataFactory.createRequirement((String)"osgi.bundle", (String)requiredBundle.getName(), (VersionRange)versionRange, null, (int)1, (int)1, (boolean)true));
        }
    }

    protected void createAdviceFileAdvice(BundleDescription bundleDescription, IPublisherInfo publisherInfo) {
        String location = bundleDescription.getLocation();
        if (location == null) {
            return;
        }
        File adviceFile = new File(location, AdviceFileAdvice.BUNDLE_ADVICE_FILE.toString());
        if (!adviceFile.canRead()) {
            return;
        }
        LinkedHashMap<String, String> advice = new LinkedHashMap<String, String>();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(adviceFile));
            try {
                Properties props = new Properties();
                props.load(is);
                for (Map.Entry<Object, Object> p : props.entrySet()) {
                    advice.put((String)p.getKey(), (String)p.getValue());
                }
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            return;
        }
        final String symbolicName = bundleDescription.getSymbolicName();
        final org.eclipse.equinox.p2.metadata.Version bundleVersion = PublisherHelper.fromOSGiVersion((Version)bundleDescription.getVersion());
        AdviceFileParser parser = new AdviceFileParser(symbolicName, bundleVersion, advice){

            protected IRequirement createRequirement(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
                if (BundleDependenciesAction.this.optionalAction == OptionalResolutionAction.OPTIONAL) {
                    return super.createRequirement(namespace, name, range, filter, optional, multiple, greedy);
                }
                return BundleDependenciesAction.this.createRequirement(namespace, name, range, filter, optional, multiple, greedy);
            }
        };
        try {
            parser.parse();
        }
        catch (Exception e) {
            return;
        }
        final IProvidedCapability[] provided = parser.getProvidedCapabilities();
        final IRequirement[] required = parser.getRequiredCapabilities();
        if (provided == null && required == null) {
            return;
        }
        publisherInfo.addAdvice((IPublisherAdvice)new ICapabilityAdvice(){

            public boolean isApplicable(String configSpec, boolean includeDefault, String id, org.eclipse.equinox.p2.metadata.Version version) {
                return symbolicName.equals(id) && bundleVersion.equals(version);
            }

            public IRequirement[] getRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return required;
            }

            public IProvidedCapability[] getProvidedCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return provided;
            }

            public IRequirement[] getMetaRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return null;
            }
        });
    }

    IRequirement createRequirement(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
        if (optional && this.optionalAction == OptionalResolutionAction.IGNORE) {
            return null;
        }
        return MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, (String)filter, (boolean)false, (boolean)multiple, (boolean)true);
    }
}

