/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.repository.FileArtifactRepository;
import org.eclipse.tycho.p2.target.repository.SupplierMetadataRepository;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.osgi.framework.BundleException;

public class FileTargetDefinitionContent
implements TargetDefinitionContent {
    private Map<IArtifactDescriptor, IInstallableUnit> repositoryContent = new HashMap<IArtifactDescriptor, IInstallableUnit>();
    private final SupplierMetadataRepository metadataRepository;
    private final FileArtifactRepository artifactRepository;
    private File location;
    private boolean loaded;

    public FileTargetDefinitionContent(IProvisioningAgent agent, File location) {
        this.location = location;
        this.metadataRepository = new SupplierMetadataRepository(agent, () -> this.getRepositoryContent().values().iterator());
        this.metadataRepository.setLocation(location.toURI());
        this.metadataRepository.setName(location.getName());
        this.artifactRepository = new FileArtifactRepository(agent, () -> this.getRepositoryContent().keySet().iterator());
        this.artifactRepository.setName(location.getName());
        this.artifactRepository.setLocation(location.toURI());
    }

    @Override
    public IMetadataRepository getMetadataRepository() {
        this.preload(null);
        return this.metadataRepository;
    }

    @Override
    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        this.preload((IProgressMonitor)subMonitor.split(100));
        subMonitor.setWorkRemaining(100);
        return this.getMetadataRepository().query(query, (IProgressMonitor)subMonitor.split(100));
    }

    public synchronized void preload(IProgressMonitor monitor) {
        if (this.loaded) {
            return;
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
            File pluginsPath = new File(this.location, "plugins");
            File featurePath = new File(this.location, "features");
            boolean hasPlugins = pluginsPath.isDirectory();
            boolean hasFeatures = featurePath.isDirectory();
            if (hasPlugins) {
                FileTargetDefinitionContent.readBundles(pluginsPath, this.repositoryContent::put, (IProgressMonitor)(hasFeatures ? subMonitor.split(100) : subMonitor));
            }
            if (hasFeatures) {
                FileTargetDefinitionContent.readFeatures(featurePath, this.repositoryContent::put, (IProgressMonitor)(hasPlugins ? subMonitor.split(100) : subMonitor));
            }
            if (!hasFeatures && !hasPlugins) {
                FileTargetDefinitionContent.readBundles(this.location, this.repositoryContent::put, (IProgressMonitor)subMonitor.split(100));
                FileTargetDefinitionContent.readFeatures(this.location, this.repositoryContent::put, (IProgressMonitor)subMonitor.split(100));
            }
        }
        catch (ResolverException e) {
            throw new TargetDefinitionResolutionException("resolving location " + this.location + " failed", (Throwable)e);
        }
        this.loaded = true;
    }

    @Override
    public IArtifactRepository getArtifactRepository() {
        this.preload(null);
        return this.artifactRepository;
    }

    private Map<IArtifactDescriptor, IInstallableUnit> getRepositoryContent() {
        return this.repositoryContent;
    }

    private static void readFeatures(File path, BiConsumer<IArtifactDescriptor, IInstallableUnit> consumer, IProgressMonitor monitor) throws ResolverException {
        File[] files;
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("reading features from path " + path + "..."), (int)files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File featureLocation = fileArray[n2];
                if (monitor.isCanceled()) break;
                String name = featureLocation.getName();
                if (!(name.startsWith(".") || featureLocation.isFile() && !name.toLowerCase().endsWith(".jar"))) {
                    subMonitor.subTask("Reading " + name);
                    Feature feature = new FeatureParser().parse(featureLocation);
                    if (feature != null) {
                        feature.setLocation(featureLocation.getAbsolutePath());
                        consumer.accept(FileArtifactRepository.forFile(featureLocation, FeaturesAction.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion())), FeaturesAction.createFeatureJarIU((Feature)feature, (IPublisherInfo)publisherInfo));
                    }
                    subMonitor.worked(1);
                }
                ++n2;
            }
        }
    }

    private static void readBundles(File path, BiConsumer<IArtifactDescriptor, IInstallableUnit> consumer, IProgressMonitor monitor) throws ResolverException {
        File[] files;
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("reading bundles from path " + path + "..."), (int)files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File bundleLocation = fileArray[n2];
                if (monitor.isCanceled()) break;
                String name = bundleLocation.getName();
                if (!(name.startsWith(".") || bundleLocation.isFile() && !name.toLowerCase().endsWith(".jar"))) {
                    subMonitor.subTask("Reading " + name);
                    try {
                        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleLocation);
                        if (bundleDescription != null) {
                            IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
                            consumer.accept(FileArtifactRepository.forFile(bundleLocation, key), BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)key, (IPublisherInfo)publisherInfo));
                        }
                    }
                    catch (IOException | BundleException e) {
                        throw new ResolverException("Reading bundle failed", e);
                    }
                    subMonitor.worked(1);
                }
                ++n2;
            }
        }
    }
}

