/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.remote.TychoRepositoryTransport;

public class TychoRepositoryTransportCacheManager
extends CacheManager {
    private static final List<String> EXTENSIONS = List.of(".jar", ".xml");
    private MavenContext mavenContext;
    private TychoRepositoryTransport transport;

    public TychoRepositoryTransportCacheManager(TychoRepositoryTransport transport, MavenContext mavenContext) {
        super(null, (Transport)transport);
        this.transport = transport;
        this.mavenContext = mavenContext;
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        if (TychoRepositoryTransport.isHttp(repositoryLocation)) {
            for (String extension : EXTENSIONS) {
                URI fileLocation = URIUtil.append((URI)repositoryLocation, (String)(String.valueOf(prefix) + extension));
                try {
                    File cachedFile = this.transport.getCachedFile(fileLocation);
                    if (cachedFile == null) continue;
                    return cachedFile;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            throw new FileNotFoundException("Not found any of " + EXTENSIONS + " for " + repositoryLocation + " with prefix " + prefix);
        }
        return super.createCache(repositoryLocation, prefix, monitor);
    }

    public File createCacheFromFile(URI remoteFile, IProgressMonitor monitor) throws ProvisionException, IOException {
        File cachedFile = this.transport.getCachedFile(remoteFile);
        if (cachedFile != null) {
            return cachedFile;
        }
        return super.createCacheFromFile(remoteFile, monitor);
    }

    protected File getCacheDirectory() {
        return new File(this.mavenContext.getLocalRepositoryRoot(), ".cache/tycho/p2-repository-metadata");
    }
}

