/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.repository;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.p2.resolver.FileTargetDefinitionContent;

public final class FileArtifactRepository
extends AbstractArtifactRepository
implements IFileArtifactRepository {
    private Supplier<Iterator<IArtifactDescriptor>> descriptorSupplier;

    public FileArtifactRepository(IProvisioningAgent agent, Supplier<Iterator<IArtifactDescriptor>> descriptorSupplier) {
        super(agent, null, null, null, null, null, null, null);
        this.descriptorSupplier = descriptorSupplier;
    }

    public synchronized void setLocation(URI location) {
        super.setLocation(location);
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        block23: {
            File artifactFile = this.getArtifactFile(descriptor);
            if (artifactFile == null) {
                return new Status(4, FileTargetDefinitionContent.class.getName(), "Artifact not found");
            }
            try {
                if (artifactFile.isDirectory()) {
                    File manifestFile = new File(artifactFile, "META-INF/MANIFEST.MF");
                    Throwable throwable = null;
                    Object var7_13 = null;
                    try (JarOutputStream jarOutputStream = new JarOutputStream(destination);){
                        if (manifestFile.exists()) {
                            Manifest manifest = new Manifest(new FileInputStream(manifestFile));
                            manifest.getMainAttributes().putValue("Eclipse-BundleShape", "dir");
                            jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                            manifest.write(jarOutputStream);
                            jarOutputStream.closeEntry();
                        }
                        this.copyToStream(artifactFile, jarOutputStream, null, f -> !f.equals(manifestFile));
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Throwable manifestFile = null;
                Object var6_11 = null;
                try (FileInputStream inputStream = new FileInputStream(artifactFile);){
                    inputStream.transferTo(destination);
                }
                catch (Throwable throwable) {
                    if (manifestFile == null) {
                        manifestFile = throwable;
                    } else if (manifestFile != throwable) {
                        manifestFile.addSuppressed(throwable);
                    }
                    throw manifestFile;
                }
            }
            catch (IOException e) {
                return new Status(4, FileTargetDefinitionContent.class.getName(), "transfer failed", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private void copyToStream(File file, ZipOutputStream os, String path, FileFilter fileFilter) throws IOException {
        block14: {
            if (file.isFile()) {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    ZipEntry entry = new ZipEntry(path == null ? file.getName() : String.valueOf(path) + file.getName());
                    entry.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
                    os.putNextEntry(entry);
                    is.transferTo(os);
                    os.closeEntry();
                    break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (file.isDirectory()) {
                File[] files = file.listFiles(fileFilter);
                if (files != null && files.length > 0) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file2 = fileArray[n2];
                        this.copyToStream(file2, os, path == null ? "" : String.valueOf(path) + file.getName() + "/", fileFilter);
                        ++n2;
                    }
                }
            } else {
                throw new IOException("file " + file.getAbsolutePath() + " is neither a readable file nor a readable directory");
            }
        }
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        return (query, monitor) -> query.perform(this.descriptorSupplier.get());
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        final Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
        return query.perform((Iterator)new Iterator<IArtifactKey>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public IArtifactKey next() {
                IArtifactDescriptor next = (IArtifactDescriptor)iterator.next();
                return next.getArtifactKey();
            }
        });
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
        while (iterator.hasNext()) {
            IArtifactDescriptor thisArtifactDescriptor = iterator.next();
            if (!thisArtifactDescriptor.equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IArtifactKey key) {
        Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
        while (iterator.hasNext()) {
            IArtifactDescriptor descriptor = iterator.next();
            if (!FileArtifactRepository.matches(key, descriptor)) continue;
            return true;
        }
        return false;
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getRawArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
        while (iterator.hasNext()) {
            IArtifactDescriptor descriptor = iterator.next();
            if (!FileArtifactRepository.matches(key, descriptor)) continue;
            return new IArtifactDescriptor[]{descriptor};
        }
        return new IArtifactDescriptor[0];
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.length);
        MultiStatus multiStatus = new MultiStatus(FileTargetDefinitionContent.class.getName(), 1, "Request Status");
        boolean ok = true;
        IArtifactRequest[] iArtifactRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRequest request = iArtifactRequestArray[n2];
            request.perform((IArtifactRepository)this, (IProgressMonitor)convert.split(1));
            IStatus result = request.getResult();
            multiStatus.add(result);
            ok &= result.isOK();
            ++n2;
        }
        return ok ? Status.OK_STATUS : multiStatus;
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        throw new ProvisionException("read only");
    }

    public File getArtifactFile(IArtifactKey key) {
        Iterator<IArtifactDescriptor> iterator = this.descriptorSupplier.get();
        while (iterator.hasNext()) {
            IArtifactDescriptor descriptor = iterator.next();
            if (!FileArtifactRepository.matches(key, descriptor)) continue;
            return this.getArtifactFile(descriptor);
        }
        return null;
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        if (descriptor instanceof FileArtifactDescriptor) {
            return ((FileArtifactDescriptor)descriptor).file;
        }
        return null;
    }

    private static boolean matches(IArtifactKey key, IArtifactDescriptor descriptor) {
        IArtifactKey descriptorKey = descriptor.getArtifactKey();
        return descriptorKey == key || key.getId().equals(descriptorKey.getId()) && key.getClassifier().equals(descriptorKey.getClassifier()) && key.getVersion().equals(descriptorKey.getVersion());
    }

    public static IArtifactDescriptor forFile(File file, IArtifactKey key) {
        return new FileArtifactDescriptor(file, key);
    }

    private static final class FileArtifactDescriptor
    extends ArtifactDescriptor {
        private File file;

        private FileArtifactDescriptor(File file, IArtifactKey key) {
            super(key);
            this.file = file;
        }
    }
}

