/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.PreliminaryTargetPlatformImpl;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.repository.module.PublishingRepositoryImpl;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.registry.ReactorRepositoryManager;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManagerFacade;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ReactorRepositoryManager.class, ReactorRepositoryManagerFacade.class})
public class ReactorRepositoryManagerImpl
implements ReactorRepositoryManager {
    private static final String PRELIMINARY_TARGET_PLATFORM_KEY = String.valueOf(ReactorRepositoryManagerImpl.class.getName()) + "/dependencyOnlyTargetPlatform";
    private IProvisioningAgentProvider agentFactory;
    private File agentDir;
    private IProvisioningAgent agent;
    private TargetPlatformFactory tpFactory;

    @Reference
    public void bindProvisioningAgentFactory(IProvisioningAgentProvider agentFactory) {
        this.agentFactory = agentFactory;
    }

    @Reference
    public void bindP2ResolverFactory(P2ResolverFactory p2ResolverFactory) {
        this.tpFactory = p2ResolverFactory.getTargetPlatformFactory();
    }

    @Activate
    public void activateManager() throws IOException, ProvisionException {
        this.agentDir = ReactorRepositoryManagerImpl.createTempDir("tycho_reactor_agent");
        this.agent = this.agentFactory.createAgent(this.agentDir.toURI());
    }

    @Deactivate
    public void deactivateManager() {
        this.agent.stop();
        FileUtils.deleteAll((File)this.agentDir);
    }

    public IProvisioningAgent getAgent() {
        return this.agent;
    }

    public PublishingRepository getPublishingRepository(ReactorProjectIdentities project) {
        return new PublishingRepositoryImpl(this.agent, project);
    }

    public TargetPlatform computePreliminaryTargetPlatform(ReactorProject project, TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfiguration, List<ReactorProject> reactorProjects) {
        TargetPlatform result = this.tpFactory.createTargetPlatform(tpConfiguration, eeConfiguration, reactorProjects);
        project.setContextValue(PRELIMINARY_TARGET_PLATFORM_KEY, (Object)result);
        List repositoryReferences = tpConfiguration.getTargetDefinitions().stream().flatMap(definition -> definition.getLocations().stream()).filter(TargetDefinition.MavenGAVLocation.class::isInstance).map(TargetDefinition.MavenGAVLocation.class::cast).flatMap(location -> location.getRepositoryReferences().stream()).collect(Collectors.toList());
        project.setContextValue(TychoConstants.CTX_REPOSITORY_REFERENCE, repositoryReferences);
        return result;
    }

    public TargetPlatform computeFinalTargetPlatform(ReactorProject project, List<? extends ReactorProjectIdentities> upstreamProjects, PomDependencyCollector pomDependencyCollector) {
        PreliminaryTargetPlatformImpl preliminaryTargetPlatform = this.getRegisteredPreliminaryTargetPlatform(project);
        if (preliminaryTargetPlatform == null) {
            return null;
        }
        List<PublishingRepository> upstreamProjectResults = this.getBuildResults(upstreamProjects);
        TargetPlatform result = this.tpFactory.createTargetPlatformWithUpdatedReactorContent((TargetPlatform)preliminaryTargetPlatform, upstreamProjectResults, pomDependencyCollector);
        project.setContextValue("org.eclipse.tycho.core.TychoConstants/targetPlatform", (Object)result);
        return result;
    }

    private PreliminaryTargetPlatformImpl getRegisteredPreliminaryTargetPlatform(ReactorProject project) {
        Object result = project.getContextValue(PRELIMINARY_TARGET_PLATFORM_KEY);
        if (result instanceof PreliminaryTargetPlatformImpl) {
            return (PreliminaryTargetPlatformImpl)result;
        }
        return null;
    }

    private List<PublishingRepository> getBuildResults(List<? extends ReactorProjectIdentities> projects) {
        ArrayList<PublishingRepository> results = new ArrayList<PublishingRepository>(projects.size());
        for (ReactorProjectIdentities reactorProjectIdentities : projects) {
            results.add(this.getPublishingRepository(reactorProjectIdentities));
        }
        return results;
    }

    public TargetPlatform getFinalTargetPlatform(ReactorProject project) {
        TargetPlatform targetPlatform = (TargetPlatform)project.getContextValue("org.eclipse.tycho.core.TychoConstants/targetPlatform");
        if (targetPlatform == null) {
            throw new IllegalStateException("Target platform is missing");
        }
        return targetPlatform;
    }

    private static File createTempDir(String prefix) throws IOException {
        File tempFile = File.createTempFile(prefix, "");
        tempFile.delete();
        tempFile.mkdirs();
        if (!tempFile.isDirectory()) {
            throw new IOException("Failed to create temporary directory: " + tempFile);
        }
        return tempFile;
    }
}

