/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.remote.DownloadStatusOutputStream;
import org.eclipse.tycho.p2.remote.SharedHttpCacheStorage;

public class TychoRepositoryTransport
extends Transport
implements IAgentServiceFactory {
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private MavenContext mavenContext;
    private SharedHttpCacheStorage httpCache;
    private LongAdder requests = new LongAdder();
    private LongAdder indexRequests = new LongAdder();
    private IProxyService proxyService;
    private Function<URI, MavenRepositorySettings.Credentials> credentialsProvider;

    public TychoRepositoryTransport(MavenContext mavenContext, IProxyService proxyService, Function<URI, MavenRepositorySettings.Credentials> credentialsProvider) {
        this.mavenContext = mavenContext;
        this.proxyService = proxyService;
        this.credentialsProvider = credentialsProvider;
        File cacheLocation = new File(mavenContext.getLocalRepositoryRoot(), ".cache/tycho");
        cacheLocation.mkdirs();
        MavenLogger logger = mavenContext.getLogger();
        logger.info("### Using TychoRepositoryTransport for remote P2 access ###");
        logger.info("    Cache location:         " + cacheLocation);
        logger.info("    Transport mode:         " + (mavenContext.isOffline() ? "offline" : "online"));
        logger.info("    Update mode:            " + (mavenContext.isUpdateSnapshots() ? "forced" : "cache first"));
        logger.info("    Minimum cache duration: " + SharedHttpCacheStorage.MIN_CACHE_PERIOD + " minutes");
        logger.info("      (you can configure this with -Dtycho.p2.transport.min-cache-minutes=<desired minimum cache duration>)");
        this.numberFormat.setMaximumFractionDigits(2);
        this.httpCache = SharedHttpCacheStorage.getStorage(cacheLocation, mavenContext.isOffline(), mavenContext.isUpdateSnapshots());
    }

    public IStatus download(URI toDownload, OutputStream target, long startPos, IProgressMonitor monitor) {
        if (startPos > 0L) {
            return new Status(4, TychoRepositoryTransport.class.getName(), "range downloads are not implemented");
        }
        return this.download(toDownload, target, monitor);
    }

    public IStatus download(URI toDownload, OutputStream target, IProgressMonitor monitor) {
        try {
            DownloadStatusOutputStream statusOutputStream = new DownloadStatusOutputStream(target, "Download of " + toDownload);
            this.stream(toDownload, monitor).transferTo(statusOutputStream);
            DownloadStatus downloadStatus = statusOutputStream.getStatus();
            return this.reportStatus((IStatus)downloadStatus, target);
        }
        catch (AuthenticationFailedException e) {
            return new Status(4, TychoRepositoryTransport.class.getName(), "authentication failed for " + toDownload, (Throwable)e);
        }
        catch (IOException e) {
            return this.reportStatus((IStatus)new Status(4, TychoRepositoryTransport.class.getName(), "download from " + toDownload + " failed", (Throwable)e), target);
        }
        catch (CoreException e) {
            return this.reportStatus(e.getStatus(), target);
        }
    }

    private IStatus reportStatus(IStatus status, OutputStream target) {
        if (target instanceof IStateful) {
            IStateful stateful = (IStateful)target;
            stateful.setStatus(status);
        }
        return status;
    }

    public synchronized InputStream stream(URI toDownload, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
        MavenLogger logger = this.mavenContext.getLogger();
        if (logger.isExtendedDebugEnabled()) {
            logger.debug("Request stream for " + toDownload + "...");
        }
        this.requests.increment();
        if (toDownload.toASCIIString().endsWith("p2.index")) {
            this.indexRequests.increment();
        }
        try {
            File cachedFile = this.getCachedFile(toDownload);
            if (cachedFile != null) {
                if (logger.isExtendedDebugEnabled()) {
                    logger.debug(" --> routed through http-cache ...");
                }
                FileInputStream fileInputStream = new FileInputStream(cachedFile);
                return fileInputStream;
            }
            InputStream inputStream = toDownload.toURL().openStream();
            return inputStream;
        }
        catch (FileNotFoundException e) {
            if (logger.isExtendedDebugEnabled()) {
                logger.debug(" --> not found!");
            }
            throw e;
        }
        catch (IOException e) {
            if (logger.isExtendedDebugEnabled()) {
                logger.debug(" --> generic error: " + e);
            }
            throw new CoreException((IStatus)new Status(4, TychoRepositoryTransport.class.getName(), "download from " + toDownload + " failed", (Throwable)e));
        }
        finally {
            if (logger.isExtendedDebugEnabled()) {
                logger.debug("Total number of requests: " + this.requests.longValue() + " (" + this.indexRequests.longValue() + " for p2.index)");
            }
        }
    }

    public long getLastModified(URI toDownload, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        try {
            if (TychoRepositoryTransport.isHttp(toDownload)) {
                return this.httpCache.getCacheEntry(toDownload, this.mavenContext.getLogger()).getLastModified(this.proxyService, this.credentialsProvider);
            }
            URLConnection connection = toDownload.toURL().openConnection();
            long lastModified = connection.getLastModified();
            connection.getInputStream().close();
            return lastModified;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, TychoRepositoryTransport.class.getName(), "download from " + toDownload + " failed", (Throwable)e));
        }
    }

    public Object createService(IProvisioningAgent agent) {
        return this;
    }

    public SharedHttpCacheStorage getHttpCache() {
        return this.httpCache;
    }

    public File getCachedFile(URI remoteFile) throws IOException {
        if (TychoRepositoryTransport.isHttp(remoteFile)) {
            return this.httpCache.getCacheEntry(remoteFile, this.mavenContext.getLogger()).getCacheFile(this.proxyService, this.credentialsProvider);
        }
        return null;
    }

    public static boolean isHttp(URI remoteFile) {
        String scheme = remoteFile.getScheme();
        return scheme != null && scheme.toLowerCase().startsWith("http");
    }
}

