/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.shared.DependencyResolutionException;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenDependenciesResolver;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MavenModelFacade;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.resolver.FeatureGenerator;
import org.eclipse.tycho.p2.resolver.FeaturePublisher;
import org.eclipse.tycho.p2.resolver.WrappedArtifact;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.repository.FileArtifactRepository;
import org.eclipse.tycho.p2.target.repository.SupplierMetadataRepository;
import org.osgi.framework.BundleException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenTargetDefinitionContent
implements TargetDefinitionContent {
    private static final String POM_PACKAGING_TYPE = "pom";
    public static final String ECLIPSE_SOURCE_BUNDLE_HEADER = "Eclipse-SourceBundle";
    private final Map<IArtifactDescriptor, IInstallableUnit> repositoryContent = new HashMap<IArtifactDescriptor, IInstallableUnit>();
    private SupplierMetadataRepository metadataRepository;
    private FileArtifactRepository artifactRepository;
    private MavenContext mavenContext;

    public MavenTargetDefinitionContent(TargetDefinition.MavenGAVLocation location, MavenDependenciesResolver mavenDependenciesResolver, IncludeSourceMode sourceMode, IProvisioningAgent agent, MavenContext mavenContext) {
        this.mavenContext = mavenContext;
        MavenLogger logger = mavenContext.getLogger();
        File repositoryRoot = mavenDependenciesResolver.getRepositoryRoot();
        boolean includeSource = sourceMode == IncludeSourceMode.force || sourceMode == IncludeSourceMode.honor && location.includeSource();
        this.metadataRepository = new SupplierMetadataRepository(agent, () -> this.repositoryContent.values().iterator());
        this.metadataRepository.setLocation(repositoryRoot.toURI());
        this.metadataRepository.setName(repositoryRoot.getName());
        this.artifactRepository = new FileArtifactRepository(agent, () -> this.repositoryContent.keySet().stream().filter(Predicate.not(FeaturePublisher::isMetadataOnly)).iterator());
        this.artifactRepository.setName(repositoryRoot.getName());
        this.artifactRepository.setLocation(repositoryRoot.toURI());
        Collection instructions = location.getInstructions();
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (mavenDependenciesResolver != null) {
            logger.info("Resolving " + location + "...");
            HashMap<String, Object> instructionsMap = new HashMap<String, Object>();
            for (TargetDefinition.BNDInstructions instruction : instructions) {
                String reference = instruction.getReference();
                Properties properties = instruction.getInstructions();
                instructionsMap.put(reference, properties);
                logger.info(String.valueOf(reference.isEmpty() ? "default instructions" : reference) + " = " + properties);
            }
            ArrayList<IInstallableUnit> locationBundles = new ArrayList<IInstallableUnit>();
            ArrayList<IInstallableUnit> locationSourceBundles = new ArrayList<IInstallableUnit>();
            for (TargetDefinition.MavenDependency mavenDependency : location.getRoots()) {
                Collection resolve;
                TargetDefinition.MavenGAVLocation.DependencyDepth dependencyDepth = location.getIncludeDependencyDepth();
                if (dependencyDepth == TargetDefinition.MavenGAVLocation.DependencyDepth.NONE && POM_PACKAGING_TYPE.equalsIgnoreCase(mavenDependency.getArtifactType())) {
                    dependencyDepth = TargetDefinition.MavenGAVLocation.DependencyDepth.DIRECT;
                }
                int depth = switch (dependencyDepth) {
                    case TargetDefinition.MavenGAVLocation.DependencyDepth.INFINITE -> Integer.MAX_VALUE;
                    case TargetDefinition.MavenGAVLocation.DependencyDepth.DIRECT -> 2;
                    default -> 0;
                };
                try {
                    resolve = mavenDependenciesResolver.resolve(mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getVersion(), mavenDependency.getArtifactType(), mavenDependency.getClassifier(), location.getIncludeDependencyScopes(), depth, location.getRepositoryReferences());
                }
                catch (DependencyResolutionException e1) {
                    throw new TargetDefinitionResolutionException("MavenDependency " + mavenDependency + " of location " + location + " could not be resolved", (Throwable)e1);
                }
                Iterator resolvedArtifacts = resolve.stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).iterator();
                Properties defaultProperties = WrappedArtifact.createPropertiesForPrefix("wrapped");
                ArrayList<IInstallableUnit> bundles = new ArrayList<IInstallableUnit>();
                ArrayList<IInstallableUnit> sourceBundles = new ArrayList<IInstallableUnit>();
                while (resolvedArtifacts.hasNext()) {
                    String bundleVersion;
                    String symbolicName;
                    Object jarEntry;
                    IArtifactFacade mavenArtifact = (IArtifactFacade)resolvedArtifacts.next();
                    if (mavenDependency.isIgnored(mavenArtifact)) {
                        logger.debug("Skip ignored " + mavenArtifact + "...");
                        continue;
                    }
                    if (POM_PACKAGING_TYPE.equalsIgnoreCase(mavenArtifact.getPackagingType())) {
                        logger.debug("Skip pom artifact " + mavenArtifact + "...");
                        continue;
                    }
                    String fileName = mavenArtifact.getLocation().getName();
                    if (!"jar".equalsIgnoreCase(FilenameUtils.getExtension((String)fileName))) {
                        logger.info("Skip non-jar artifact ... (" + fileName + ")");
                        continue;
                    }
                    logger.debug("Resolved " + mavenArtifact + "...");
                    Feature feature = new FeatureParser().parse(mavenArtifact.getLocation());
                    if (feature != null) {
                        feature.setLocation(mavenArtifact.getLocation().getAbsolutePath());
                        features.add(feature);
                        continue;
                    }
                    try {
                        IInstallableUnit unit;
                        File bundleLocation = mavenArtifact.getLocation();
                        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)bundleLocation);
                        if (bundleDescription == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Bundle Location:       " + bundleLocation + " (Filesize " + (bundleLocation != null ? bundleLocation.length() : -1L) + ")");
                                boolean isFile = bundleLocation != null && bundleLocation.isFile();
                                logger.debug("File isFile:           " + isFile);
                                if (isFile) {
                                    try {
                                        Throwable throwable = null;
                                        Object var34_40 = null;
                                        try (JarFile jarFile = new JarFile(bundleLocation);){
                                            Enumeration<JarEntry> entries = jarFile.entries();
                                            while (entries.hasMoreElements()) {
                                                jarEntry = entries.nextElement();
                                                logger.debug("                Entry: " + ((ZipEntry)jarEntry).getName());
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.debug("Reading as jar failed: " + e);
                                    }
                                }
                            }
                            throw new TargetDefinitionResolutionException("Artifact " + mavenArtifact + " of location " + location + " is not a valid jar file");
                        }
                        symbolicName = bundleDescription.getSymbolicName();
                        bundleVersion = bundleDescription.getVersion().toString();
                        if (symbolicName == null) {
                            WrappedArtifact wrappedArtifact;
                            if (location.getMissingManifestStrategy() == TargetDefinition.MavenGAVLocation.MissingManifestStrategy.IGNORE) {
                                logger.info("Ignoring " + this.asDebugString(mavenArtifact) + " as it is not a bundle and MissingManifestStrategy is set to ignore for this location");
                                continue;
                            }
                            if (location.getMissingManifestStrategy() == TargetDefinition.MavenGAVLocation.MissingManifestStrategy.ERROR) {
                                throw new TargetDefinitionResolutionException("Artifact " + this.asDebugString(mavenArtifact) + " is not a bundle and MissingManifestStrategy is set to error for this location");
                            }
                            File tempFile = File.createTempFile("tycho_wrapped_bundle", ".jar");
                            tempFile.deleteOnExit();
                            try {
                                Properties properties = instructionsMap.getOrDefault(MavenTargetDefinitionContent.getKey(mavenArtifact), instructionsMap.getOrDefault("", defaultProperties));
                                wrappedArtifact = WrappedArtifact.createWrappedArtifact(mavenArtifact, properties, tempFile);
                            }
                            catch (Exception e) {
                                throw new TargetDefinitionResolutionException("Artifact " + this.asDebugString(mavenArtifact) + " could not be wrapped", (Throwable)e);
                            }
                            logger.info(String.valueOf(this.asDebugString(mavenArtifact)) + " is wrapped as a bundle with bundle symbolic name " + wrappedArtifact.getWrappedBsn());
                            logger.info(wrappedArtifact.getReferenceHint());
                            if (logger.isDebugEnabled()) {
                                logger.debug("The following manifest was generated for this artifact:\r\n" + wrappedArtifact.getGeneratedManifest());
                            }
                            unit = this.publish(BundlesAction.createBundleDescription((File)tempFile), tempFile, null);
                            symbolicName = wrappedArtifact.getWrappedBsn();
                            bundleVersion = wrappedArtifact.getWrappedVersion();
                        } else {
                            unit = this.publish(bundleDescription, bundleLocation, mavenArtifact);
                        }
                        bundles.add(unit);
                        if (logger.isDebugEnabled()) {
                            logger.debug("MavenResolver: artifact " + this.asDebugString(mavenArtifact) + " at location " + bundleLocation + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
                        }
                    }
                    catch (IOException | BundleException e) {
                        throw new TargetDefinitionResolutionException("Artifact " + this.asDebugString(mavenArtifact) + " of location " + location + " could not be read", e);
                    }
                    if (!includeSource) continue;
                    try {
                        Collection sourceArtifacts = mavenDependenciesResolver.resolve(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), mavenArtifact.getPackagingType(), "sources", null, 0, location.getRepositoryReferences());
                        Iterator sources = sourceArtifacts.stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).iterator();
                        while (sources.hasNext()) {
                            IArtifactFacade sourceArtifact = (IArtifactFacade)sources.next();
                            File sourceFile = sourceArtifact.getLocation();
                            try {
                                Manifest manifest;
                                jarEntry = null;
                                Object var38_48 = null;
                                try (JarFile jar = new JarFile(sourceFile);){
                                    manifest = Objects.requireNonNullElseGet(jar.getManifest(), Manifest::new);
                                }
                                catch (Throwable throwable) {
                                    if (jarEntry == null) {
                                        jarEntry = throwable;
                                    } else if (jarEntry != throwable) {
                                        ((Throwable)jarEntry).addSuppressed(throwable);
                                    }
                                    throw jarEntry;
                                }
                                IInstallableUnit unit = MavenTargetDefinitionContent.isValidSourceManifest(manifest) ? this.publish(BundlesAction.createBundleDescription((File)sourceFile), sourceFile, sourceArtifact) : this.generateSourceBundle(symbolicName, bundleVersion, manifest, sourceFile, sourceArtifact);
                                sourceBundles.add(unit);
                                if (unit == null || !logger.isDebugEnabled()) continue;
                                logger.debug("MavenResolver: source-artifact " + this.asDebugString(sourceArtifact) + ":sources at location " + sourceFile + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
                            }
                            catch (IOException | BundleException e) {
                                logger.warn("MavenResolver: source-artifact " + this.asDebugString(sourceArtifact) + ":sources at location " + sourceFile + " can't be converted to a source bundle: " + e);
                            }
                        }
                    }
                    catch (DependencyResolutionException e) {
                        logger.warn("MavenResolver: source-artifact " + this.asDebugString(mavenArtifact) + ":sources can't be resolved: " + (Object)((Object)e));
                    }
                }
                if (POM_PACKAGING_TYPE.equalsIgnoreCase(mavenDependency.getArtifactType())) {
                    Optional<File> pomFacade = resolve.stream().filter(IArtifactFacade.class::isInstance).map(IArtifactFacade.class::cast).filter(facade -> facade.getDependencyTrail().size() == 1).filter(facade -> facade.getArtifactId().equals(mavenDependency.getArtifactId()) && facade.getGroupId().equals(mavenDependency.getGroupId()) && facade.getVersion().equals(mavenDependency.getVersion()) && facade.getPackagingType().equals(POM_PACKAGING_TYPE)).map(facade -> facade.getLocation()).filter(Objects::nonNull).findFirst();
                    if (pomFacade.isPresent()) {
                        try {
                            MavenModelFacade model = mavenDependenciesResolver.loadModel(pomFacade.get());
                            features.add(FeatureGenerator.generatePomFeature(model, bundles, false, logger));
                            if (includeSource) {
                                features.add(FeatureGenerator.generatePomFeature(model, sourceBundles, true, logger));
                            }
                        }
                        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                            throw new TargetDefinitionResolutionException("non readable pom file");
                        }
                    }
                }
                locationBundles.addAll(bundles);
                locationSourceBundles.addAll(sourceBundles);
            }
            Element featureTemplate = location.getFeatureTemplate();
            if (featureTemplate != null) {
                try {
                    features.add(FeatureGenerator.createFeatureFromTemplate(featureTemplate, locationBundles, false, logger));
                    if (includeSource) {
                        features.add(FeatureGenerator.createFeatureFromTemplate(featureTemplate, locationSourceBundles, true, logger));
                    }
                }
                catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                    throw new TargetDefinitionResolutionException("feature generation failed!", (Throwable)e);
                }
            }
            FeaturePublisher.publishFeatures(features, this.repositoryContent::put, logger);
        }
    }

    private IInstallableUnit generateSourceBundle(String symbolicName, String bundleVersion, Manifest manifest, File sourceFile, IArtifactFacade sourceArtifact) throws IOException, BundleException {
        File tempFile = File.createTempFile("tycho_wrapped_source", ".jar");
        tempFile.deleteOnExit();
        Attributes attr = manifest.getMainAttributes();
        if (attr.isEmpty()) {
            attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        attr.putValue(ECLIPSE_SOURCE_BUNDLE_HEADER, String.valueOf(symbolicName) + ";version=\"" + bundleVersion + "\";roots:=\".\"");
        attr.putValue("Bundle-ManifestVersion", "2");
        attr.putValue("Bundle-Name", "Source Bundle for " + symbolicName + ":" + bundleVersion);
        attr.putValue("Bundle-SymbolicName", String.valueOf(symbolicName) + ".source");
        attr.putValue("Bundle-Version", bundleVersion);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(tempFile), manifest);){
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JarFile jar = new JarFile(sourceFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    if (jarEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    Throwable throwable3 = null;
                    Object var17_22 = null;
                    try (InputStream is = jar.getInputStream(jarEntry);){
                        stream.putNextEntry(new ZipEntry(jarEntry.getName()));
                        is.transferTo(stream);
                        stream.closeEntry();
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        return this.publish(BundlesAction.createBundleDescription((File)tempFile), tempFile, sourceArtifact);
    }

    private IInstallableUnit publish(BundleDescription bundleDescription, File bundleLocation, IArtifactFacade mavenArtifact) {
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = FileArtifactRepository.forFile(bundleLocation, key);
        PublisherInfo publisherInfo = new PublisherInfo();
        if (mavenArtifact != null) {
            MavenPropertiesAdvice advice = new MavenPropertiesAdvice(mavenArtifact, this.mavenContext);
            publisherInfo.addAdvice((IPublisherAdvice)advice);
            advice.setDescriptorProperties(descriptor);
        }
        publisherInfo.setArtifactOptions(1);
        IInstallableUnit iu = BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)key, (IPublisherInfo)publisherInfo);
        this.repositoryContent.put(descriptor, iu);
        return iu;
    }

    private String asDebugString(IArtifactFacade mavenArtifact) {
        return new GAV(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion()).toString();
    }

    @Override
    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    @Override
    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    private static String getKey(IArtifactFacade artifact) {
        if (artifact == null) {
            return "";
        }
        String key = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            key = String.valueOf(key) + ":" + classifier;
        }
        key = String.valueOf(key) + ":" + artifact.getVersion();
        return key;
    }

    private static boolean isValidSourceManifest(Manifest manifest) {
        if (manifest != null) {
            return manifest.getMainAttributes().getValue(ECLIPSE_SOURCE_BUNDLE_HEADER) != null;
        }
        return false;
    }
}

