/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public abstract class DefaultTychoRepositoryIndex
implements TychoRepositoryIndex {
    private Set<GAV> gavs;

    protected DefaultTychoRepositoryIndex() {
        this(Collections.emptySet());
    }

    public DefaultTychoRepositoryIndex(Set<GAV> initialContent) {
        this.gavs = new LinkedHashSet<GAV>(initialContent);
    }

    @Override
    public Set<GAV> getProjectGAVs() {
        return Collections.unmodifiableSet(new LinkedHashSet<GAV>(this.gavs));
    }

    @Override
    public void addGav(GAV gav) {
        if (gav == null) {
            throw new NullPointerException();
        }
        this.gavs.add(gav);
    }

    @Override
    public void removeGav(GAV gav) {
        this.gavs.remove(gav);
    }

    protected void setGavs(Set<GAV> content) {
        this.gavs = content;
    }
}

