/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.surefire.junitcore.pc.ExecutionStatus;
import org.apache.maven.surefire.junitcore.pc.ShutdownResult;

final class ShutdownStatus {
    private final AtomicReference<ExecutionStatus> status = new AtomicReference<ExecutionStatus>(ExecutionStatus.STARTED);
    private Future<ShutdownResult> descriptionsBeforeShutdown;

    ShutdownStatus() {
    }

    boolean tryFinish() {
        return this.status.compareAndSet(ExecutionStatus.STARTED, ExecutionStatus.FINISHED);
    }

    boolean tryTimeout() {
        return this.status.compareAndSet(ExecutionStatus.STARTED, ExecutionStatus.TIMEOUT);
    }

    boolean isTimeoutElapsed() {
        return this.status.get() == ExecutionStatus.TIMEOUT;
    }

    Future<ShutdownResult> getDescriptionsBeforeShutdown() {
        return this.descriptionsBeforeShutdown;
    }

    void setDescriptionsBeforeShutdown(Future<ShutdownResult> descriptionsBeforeShutdown) {
        this.descriptionsBeforeShutdown = descriptionsBeforeShutdown;
    }
}

