/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.junitcore.pc.AbstractThreadPoolStrategy;

final class SharedThreadPoolStrategy
extends AbstractThreadPoolStrategy {
    SharedThreadPoolStrategy(ConsoleLogger logger, ExecutorService threadPool) {
        super(logger, threadPool, new ConcurrentLinkedQueue());
    }

    @Override
    public boolean hasSharedThreadPool() {
        return true;
    }

    @Override
    public boolean finished() throws InterruptedException {
        boolean wasRunningAll = this.disable();
        for (Future<?> futureResult : this.getFutureResults()) {
            try {
                futureResult.get();
            }
            catch (InterruptedException e) {
                wasRunningAll = false;
            }
            catch (ExecutionException e) {
                if (e.getCause() == null) continue;
                this.logQuietly(e.getCause());
            }
            catch (CancellationException cancellationException) {}
        }
        return wasRunningAll;
    }

    @Override
    protected boolean stop() {
        return this.stop(false);
    }

    @Override
    protected boolean stopNow() {
        return this.stop(true);
    }

    private boolean stop(boolean interrupt) {
        boolean wasRunning = this.disable();
        for (Future<?> futureResult : this.getFutureResults()) {
            futureResult.cancel(interrupt);
        }
        return wasRunning;
    }
}

