/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.pc.Balancer;
import org.apache.maven.surefire.junitcore.pc.BalancerFactory;
import org.apache.maven.surefire.junitcore.pc.Concurrency;
import org.apache.maven.surefire.junitcore.pc.InvokerStrategy;
import org.apache.maven.surefire.junitcore.pc.ParallelComputer;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerUtil;
import org.apache.maven.surefire.junitcore.pc.RunnerCounter;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategies;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.SharedThreadPoolStrategy;
import org.apache.maven.surefire.junitcore.pc.ShutdownResult;
import org.apache.maven.surefire.junitcore.pc.SingleThreadScheduler;
import org.apache.maven.surefire.junitcore.pc.Type;
import org.apache.maven.surefire.junitcore.pc.WrappedRunners;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;

public final class ParallelComputerBuilder {
    private static final ThreadFactory DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory();
    private static final Class<? extends Annotation> JCIP_NOT_THREAD_SAFE = ParallelComputerBuilder.loadNotThreadSafeAnnotations();
    private static final Set<Runner> NULL_SINGLETON = Collections.singleton(null);
    static final int TOTAL_POOL_SIZE_UNDEFINED = 0;
    private final Map<Type, Integer> parallelGroups = new EnumMap<Type, Integer>(Type.class);
    private final ConsoleLogger logger;
    private boolean useSeparatePools;
    private int totalPoolSize;
    private JUnitCoreParameters parameters;
    private boolean optimize;
    private boolean runningInTests;

    ParallelComputerBuilder(ConsoleLogger logger) {
        this.logger = logger;
        this.runningInTests = true;
        this.useSeparatePools();
        this.parallelGroups.put(Type.SUITES, 0);
        this.parallelGroups.put(Type.CLASSES, 0);
        this.parallelGroups.put(Type.METHODS, 0);
    }

    public ParallelComputerBuilder(ConsoleLogger logger, JUnitCoreParameters parameters) {
        this(logger);
        this.runningInTests = false;
        this.parameters = parameters;
    }

    public ParallelComputer buildComputer() {
        return new PC();
    }

    ParallelComputerBuilder useSeparatePools() {
        this.totalPoolSize = 0;
        this.useSeparatePools = true;
        return this;
    }

    ParallelComputerBuilder useOnePool() {
        this.totalPoolSize = 0;
        this.useSeparatePools = false;
        return this;
    }

    ParallelComputerBuilder useOnePool(int totalPoolSize) {
        if (totalPoolSize < 1) {
            throw new IllegalArgumentException("Size of common pool is less than 1.");
        }
        this.totalPoolSize = totalPoolSize;
        this.useSeparatePools = false;
        return this;
    }

    boolean isOptimized() {
        return this.optimize;
    }

    ParallelComputerBuilder optimize(boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    ParallelComputerBuilder parallelSuites() {
        return this.parallel(Type.SUITES);
    }

    ParallelComputerBuilder parallelSuites(int nThreads) {
        return this.parallel(nThreads, Type.SUITES);
    }

    ParallelComputerBuilder parallelClasses() {
        return this.parallel(Type.CLASSES);
    }

    ParallelComputerBuilder parallelClasses(int nThreads) {
        return this.parallel(nThreads, Type.CLASSES);
    }

    ParallelComputerBuilder parallelMethods() {
        return this.parallel(Type.METHODS);
    }

    ParallelComputerBuilder parallelMethods(int nThreads) {
        return this.parallel(nThreads, Type.METHODS);
    }

    private ParallelComputerBuilder parallel(int nThreads, Type parallelType) {
        if (nThreads < 0) {
            throw new IllegalArgumentException("negative nThreads " + nThreads);
        }
        if (parallelType == null) {
            throw new IllegalArgumentException("null parallelType");
        }
        this.parallelGroups.put(parallelType, nThreads);
        return this;
    }

    private ParallelComputerBuilder parallel(Type parallelType) {
        return this.parallel(Integer.MAX_VALUE, parallelType);
    }

    private double parallelTestsTimeoutInSeconds() {
        return this.parameters == null ? 0.0 : this.parameters.getParallelTestsTimeoutInSeconds();
    }

    private double parallelTestsTimeoutForcedInSeconds() {
        return this.parameters == null ? 0.0 : this.parameters.getParallelTestsTimeoutForcedInSeconds();
    }

    private static Class<? extends Annotation> loadNotThreadSafeAnnotations() {
        try {
            Class<?> c = Class.forName("net.jcip.annotations.NotThreadSafe");
            return c.isAnnotation() ? c : null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Suite createSuite(Collection<Runner> runners) throws InitializationError {
        List<Runner> onlyRunners = ParallelComputerBuilder.removeNullRunners(runners);
        return onlyRunners.isEmpty() ? null : new Suite(null, onlyRunners){};
    }

    private static List<Runner> removeNullRunners(Collection<Runner> runners) {
        ArrayList<Runner> onlyRunners = new ArrayList<Runner>(runners);
        onlyRunners.removeAll(NULL_SINGLETON);
        return onlyRunners;
    }

    final class PC
    extends ParallelComputer {
        private final SingleThreadScheduler notThreadSafeTests;
        private final Collection<ParentRunner> suites;
        private final Collection<ParentRunner> nestedSuites;
        private final Collection<ParentRunner> classes;
        private final Collection<ParentRunner> nestedClasses;
        private final Collection<Runner> notParallelRunners;
        private int poolCapacity;
        private boolean splitPool;
        private final Map<Type, Integer> allGroups;
        private long nestedClassesChildren;
        private volatile Scheduler master;

        private PC() {
            super(ParallelComputerBuilder.this.parallelTestsTimeoutInSeconds(), ParallelComputerBuilder.this.parallelTestsTimeoutForcedInSeconds());
            this.notThreadSafeTests = new SingleThreadScheduler(ParallelComputerBuilder.this.logger);
            this.suites = new LinkedHashSet<ParentRunner>();
            this.nestedSuites = new LinkedHashSet<ParentRunner>();
            this.classes = new LinkedHashSet<ParentRunner>();
            this.nestedClasses = new LinkedHashSet<ParentRunner>();
            this.notParallelRunners = new LinkedHashSet<Runner>();
            this.allGroups = new EnumMap<Type, Integer>(ParallelComputerBuilder.this.parallelGroups);
            this.poolCapacity = ParallelComputerBuilder.this.totalPoolSize;
            this.splitPool = ParallelComputerBuilder.this.useSeparatePools;
        }

        Collection<ParentRunner> getSuites() {
            return this.suites;
        }

        Collection<ParentRunner> getNestedSuites() {
            return this.nestedSuites;
        }

        Collection<ParentRunner> getClasses() {
            return this.classes;
        }

        Collection<ParentRunner> getNestedClasses() {
            return this.nestedClasses;
        }

        Collection<Runner> getNotParallelRunners() {
            return this.notParallelRunners;
        }

        int getPoolCapacity() {
            return this.poolCapacity;
        }

        boolean isSplitPool() {
            return this.splitPool;
        }

        @Override
        protected ShutdownResult describeStopped(boolean shutdownNow) {
            ShutdownResult shutdownResult = this.notThreadSafeTests.describeStopped(shutdownNow);
            Scheduler m = this.master;
            if (m != null) {
                ShutdownResult shutdownResultOfMaster = m.describeStopped(shutdownNow);
                shutdownResult.getTriggeredTests().addAll(shutdownResultOfMaster.getTriggeredTests());
                shutdownResult.getIncompleteTests().addAll(shutdownResultOfMaster.getIncompleteTests());
            }
            return shutdownResult;
        }

        @Override
        protected boolean shutdownThreadPoolsAwaitingKilled() {
            boolean notInterrupted = this.notThreadSafeTests.shutdownThreadPoolsAwaitingKilled();
            Scheduler m = this.master;
            if (m != null) {
                notInterrupted &= m.shutdownThreadPoolsAwaitingKilled();
            }
            return notInterrupted;
        }

        public Runner getSuite(RunnerBuilder builder, Class<?>[] cls) throws InitializationError {
            try {
                super.getSuite(builder, (Class[])cls);
                this.populateChildrenFromSuites();
                WrappedRunners suiteSuites = this.wrapRunners(this.suites);
                WrappedRunners suiteClasses = this.wrapRunners(this.classes);
                long suitesCount = this.suites.size();
                long classesCount = this.classes.size() + this.nestedClasses.size();
                long methodsCount = suiteClasses.embeddedChildrenCount + this.nestedClassesChildren;
                if (!ParallelComputerBuilder.this.runningInTests) {
                    this.determineThreadCounts(suitesCount, classesCount, methodsCount);
                }
                return this.setSchedulers(suiteSuites.wrappingSuite, suiteClasses.wrappingSuite);
            }
            catch (TestSetFailedException e) {
                throw new InitializationError(Collections.singletonList(e));
            }
        }

        protected Runner getRunner(RunnerBuilder builder, Class<?> testClass) throws Throwable {
            Runner runner = super.getRunner(builder, testClass);
            if (this.canSchedule(runner)) {
                if (!this.isThreadSafe(runner)) {
                    ((ParentRunner)runner).setScheduler(this.notThreadSafeTests.newRunnerScheduler());
                    this.notParallelRunners.add(runner);
                } else if (runner instanceof Suite) {
                    this.suites.add((ParentRunner)((Suite)runner));
                } else {
                    this.classes.add((ParentRunner)runner);
                }
            } else {
                this.notParallelRunners.add(runner);
            }
            return runner;
        }

        private void determineThreadCounts(long suites, long classes, long methods) throws TestSetFailedException {
            RunnerCounter counts = ParallelComputerBuilder.this.optimize ? new RunnerCounter(suites, classes, methods) : null;
            Concurrency concurrency = ParallelComputerUtil.resolveConcurrency(ParallelComputerBuilder.this.parameters, counts);
            this.allGroups.put(Type.SUITES, concurrency.suites);
            this.allGroups.put(Type.CLASSES, concurrency.classes);
            this.allGroups.put(Type.METHODS, concurrency.methods);
            this.poolCapacity = concurrency.capacity;
            this.splitPool &= concurrency.capacity <= 0;
        }

        private <T extends Runner> WrappedRunners wrapRunners(Collection<T> runners) throws InitializationError {
            long childrenCounter = 0L;
            ArrayList<Runner> runs = new ArrayList<Runner>();
            for (Runner runner : runners) {
                if (runner == null) continue;
                int children = this.countChildren(runner);
                childrenCounter += (long)children;
                runs.add(runner);
            }
            return runs.isEmpty() ? new WrappedRunners() : new WrappedRunners((ParentRunner)ParallelComputerBuilder.createSuite(runs), childrenCounter);
        }

        private int countChildren(Runner runner) {
            Description description = runner.getDescription();
            ArrayList children = description == null ? null : description.getChildren();
            return children == null ? 0 : children.size();
        }

        private ExecutorService createPool(int poolSize) {
            return poolSize < Integer.MAX_VALUE ? Executors.newFixedThreadPool(poolSize, DAEMON_THREAD_FACTORY) : Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY);
        }

        private Scheduler createMaster(ExecutorService pool, int poolSize) {
            int finalRunnersCounter = this.countFinalRunners();
            SchedulingStrategy strategy = finalRunnersCounter <= 1 || poolSize <= 1 ? new InvokerStrategy(ParallelComputerBuilder.this.logger) : (pool != null && poolSize == Integer.MAX_VALUE ? new SharedThreadPoolStrategy(ParallelComputerBuilder.this.logger, pool) : SchedulingStrategies.createParallelStrategy(ParallelComputerBuilder.this.logger, finalRunnersCounter));
            return new Scheduler(ParallelComputerBuilder.this.logger, null, strategy);
        }

        private int countFinalRunners() {
            int counter;
            int n = counter = this.notParallelRunners.isEmpty() ? 0 : 1;
            if (!this.suites.isEmpty() && this.allGroups.get((Object)Type.SUITES) > 0) {
                ++counter;
            }
            if (!this.classes.isEmpty() && this.allGroups.get((Object)Type.CLASSES) > 0) {
                ++counter;
            }
            return counter;
        }

        private void populateChildrenFromSuites() {
            SuiteFilter filter = new SuiteFilter();
            Iterator<ParentRunner> it = this.suites.iterator();
            while (it.hasNext()) {
                ParentRunner suite = it.next();
                try {
                    suite.filter((Filter)filter);
                }
                catch (NoTestsRemainException e) {
                    it.remove();
                }
            }
        }

        private int totalPoolSize() {
            if (this.poolCapacity == 0) {
                int total = 0;
                for (int nThreads : this.allGroups.values()) {
                    if ((total += nThreads) >= 0) continue;
                    total = Integer.MAX_VALUE;
                    break;
                }
                return total;
            }
            return this.poolCapacity;
        }

        private Runner setSchedulers(ParentRunner suiteSuites, ParentRunner suiteClasses) throws InitializationError {
            int parallelSuites = this.allGroups.get((Object)Type.SUITES);
            int parallelClasses = this.allGroups.get((Object)Type.CLASSES);
            int parallelMethods = this.allGroups.get((Object)Type.METHODS);
            int poolSize = this.totalPoolSize();
            ExecutorService commonPool = this.splitPool || poolSize == 0 ? null : this.createPool(poolSize);
            this.master = this.createMaster(commonPool, poolSize);
            if (suiteSuites != null) {
                if (commonPool != null && parallelSuites > 0) {
                    Balancer balancer = BalancerFactory.createBalancerWithFairness(parallelSuites);
                    suiteSuites.setScheduler((RunnerScheduler)this.createScheduler(null, commonPool, true, balancer));
                } else {
                    suiteSuites.setScheduler((RunnerScheduler)this.createScheduler(parallelSuites));
                }
            }
            ArrayList<ParentRunner> allSuites = new ArrayList<ParentRunner>(this.suites);
            allSuites.addAll(this.nestedSuites);
            if (suiteClasses != null) {
                allSuites.add(suiteClasses);
            }
            if (!allSuites.isEmpty()) {
                this.setSchedulers(allSuites, parallelClasses, commonPool);
            }
            ArrayList<ParentRunner> allClasses = new ArrayList<ParentRunner>(this.classes);
            allClasses.addAll(this.nestedClasses);
            if (!allClasses.isEmpty()) {
                this.setSchedulers(allClasses, parallelMethods, commonPool);
            }
            ParentRunner all = this.createFinalRunner(ParallelComputerBuilder.removeNullRunners(Arrays.asList(suiteSuites, suiteClasses, ParallelComputerBuilder.createSuite(this.notParallelRunners))));
            all.setScheduler((RunnerScheduler)this.master);
            return all;
        }

        private ParentRunner createFinalRunner(List<Runner> runners) throws InitializationError {
            return new Suite(null, runners){

                public void run(RunNotifier notifier) {
                    try {
                        PC.this.beforeRunQuietly();
                        super.run(notifier);
                    }
                    finally {
                        PC.this.afterRunQuietly();
                    }
                }
            };
        }

        private void setSchedulers(Iterable<? extends ParentRunner> runners, int poolSize, ExecutorService commonPool) {
            if (commonPool != null) {
                Balancer concurrencyLimit = BalancerFactory.createBalancerWithFairness(poolSize);
                boolean doParallel = poolSize > 0;
                for (ParentRunner parentRunner : runners) {
                    parentRunner.setScheduler((RunnerScheduler)this.createScheduler(parentRunner.getDescription(), commonPool, doParallel, concurrencyLimit));
                }
            } else {
                ExecutorService pool = null;
                if (poolSize == Integer.MAX_VALUE) {
                    pool = Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY);
                } else if (poolSize > 0) {
                    pool = Executors.newFixedThreadPool(poolSize, DAEMON_THREAD_FACTORY);
                }
                boolean doParallel = pool != null;
                for (ParentRunner parentRunner : runners) {
                    parentRunner.setScheduler((RunnerScheduler)this.createScheduler(parentRunner.getDescription(), pool, doParallel, BalancerFactory.createInfinitePermitsBalancer()));
                }
            }
        }

        private Scheduler createScheduler(Description desc, ExecutorService pool, boolean doParallel, Balancer concurrency) {
            SchedulingStrategy strategy = doParallel & pool != null ? new SharedThreadPoolStrategy(ParallelComputerBuilder.this.logger, pool) : new InvokerStrategy(ParallelComputerBuilder.this.logger);
            return new Scheduler(ParallelComputerBuilder.this.logger, desc, this.master, strategy, concurrency);
        }

        private Scheduler createScheduler(int poolSize) {
            SchedulingStrategy strategy = poolSize == Integer.MAX_VALUE ? SchedulingStrategies.createParallelStrategyUnbounded(ParallelComputerBuilder.this.logger) : (poolSize == 0 ? new InvokerStrategy(ParallelComputerBuilder.this.logger) : SchedulingStrategies.createParallelStrategy(ParallelComputerBuilder.this.logger, poolSize));
            return new Scheduler(ParallelComputerBuilder.this.logger, null, this.master, strategy);
        }

        private boolean canSchedule(Runner runner) {
            return !(runner instanceof ErrorReportingRunner) && runner instanceof ParentRunner;
        }

        private boolean isThreadSafe(Runner runner) {
            return runner.getDescription().getAnnotation(JCIP_NOT_THREAD_SAFE) == null;
        }

        private class SuiteFilter
        extends Filter {
            private SuiteFilter() {
            }

            public boolean shouldRun(Description description) {
                return true;
            }

            public void apply(Object child) throws NoTestsRemainException {
                super.apply(child);
                if (child instanceof ParentRunner) {
                    ParentRunner runner = (ParentRunner)child;
                    if (!PC.this.isThreadSafe((Runner)runner)) {
                        runner.setScheduler(PC.this.notThreadSafeTests.newRunnerScheduler());
                    } else if (child instanceof Suite) {
                        PC.this.nestedSuites.add((Suite)child);
                    } else {
                        ParentRunner parentRunner = (ParentRunner)child;
                        PC.this.nestedClasses.add(parentRunner);
                        PC.this.nestedClassesChildren = PC.this.nestedClassesChildren + (long)parentRunner.getDescription().getChildren().size();
                    }
                }
            }

            public String describe() {
                return "";
            }
        }
    }
}

