/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

class DefaultParameterContext
implements ParameterContext {
    private final Parameter parameter;
    private final int index;
    private final Optional<Object> target;

    DefaultParameterContext(Parameter parameter, int index, Optional<Object> target) {
        Preconditions.condition(index >= 0, "index must be greater than or equal to zero");
        this.parameter = Preconditions.notNull(parameter, "parameter must not be null");
        this.index = index;
        this.target = Preconditions.notNull(target, "target must not be null");
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public int getIndex() {
        return this.index;
    }

    public Optional<Object> getTarget() {
        return this.target;
    }

    public String toString() {
        return new ToStringBuilder(this).append("parameter", this.parameter).append("index", this.index).append("target", this.target).toString();
    }
}

