/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.platform.engine.EngineExecutionListener;

final class TestTemplateExtensionContext
extends AbstractExtensionContext<TestTemplateTestDescriptor> {
    private final Object testInstance;

    TestTemplateExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, TestTemplateTestDescriptor testDescriptor, Object testInstance) {
        super(parent, engineExecutionListener, testDescriptor);
        this.testInstance = testInstance;
    }

    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    public Optional<Class<?>> getTestClass() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    public Optional<Object> getTestInstance() {
        return Optional.ofNullable(this.testInstance);
    }

    public Optional<Method> getTestMethod() {
        return Optional.of(((TestTemplateTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    public Optional<Throwable> getExecutionException() {
        return Optional.empty();
    }
}

