/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.engine.DiscoveryFilterApplier;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;

@API(status=API.Status.INTERNAL, since="5.0")
public final class JupiterTestEngine
extends HierarchicalTestEngine<JupiterEngineExecutionContext> {
    public static final String ENGINE_ID = "junit-jupiter";

    @Override
    public String getId() {
        return ENGINE_ID;
    }

    @Override
    public Optional<String> getGroupId() {
        return Optional.of("org.junit.jupiter");
    }

    @Override
    public Optional<String> getArtifactId() {
        return Optional.of("junit-jupiter-engine");
    }

    @Override
    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        JupiterEngineDescriptor engineDescriptor = new JupiterEngineDescriptor(uniqueId);
        this.resolveDiscoveryRequest(discoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    private void resolveDiscoveryRequest(EngineDiscoveryRequest discoveryRequest, JupiterEngineDescriptor engineDescriptor) {
        DiscoverySelectorResolver resolver = new DiscoverySelectorResolver();
        resolver.resolveSelectors(discoveryRequest, engineDescriptor);
        this.applyDiscoveryFilters(discoveryRequest, engineDescriptor);
    }

    private void applyDiscoveryFilters(EngineDiscoveryRequest discoveryRequest, JupiterEngineDescriptor engineDescriptor) {
        new DiscoveryFilterApplier().applyAllFilters(discoveryRequest, engineDescriptor);
    }

    @Override
    protected JupiterEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        return new JupiterEngineExecutionContext(request.getEngineExecutionListener(), request.getConfigurationParameters());
    }
}

