/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.api.parallel.ResourceLockTarget;
import org.junit.jupiter.api.parallel.ResourceLocksProvider;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;

abstract class ExclusiveResourceCollector {
    private static final ExclusiveResourceCollector NO_EXCLUSIVE_RESOURCES = new ExclusiveResourceCollector(){

        @Override
        Stream<ExclusiveResource> getAllExclusiveResources(Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> providerToLocks) {
            return Stream.empty();
        }

        @Override
        Stream<ExclusiveResource> getStaticResourcesFor(ResourceLockTarget target) {
            return Stream.empty();
        }

        @Override
        Stream<ExclusiveResource> getDynamicResources(Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> providerToLocks) {
            return Stream.empty();
        }
    };

    ExclusiveResourceCollector() {
    }

    Stream<ExclusiveResource> getAllExclusiveResources(Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> providerToLocks) {
        return Stream.concat(this.getStaticResourcesFor(ResourceLockTarget.SELF), this.getDynamicResources(providerToLocks));
    }

    abstract Stream<ExclusiveResource> getStaticResourcesFor(ResourceLockTarget var1);

    abstract Stream<ExclusiveResource> getDynamicResources(Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> var1);

    static ExclusiveResourceCollector from(AnnotatedElement element) {
        List<ResourceLock> annotations = AnnotationSupport.findRepeatableAnnotations(element, ResourceLock.class);
        return annotations.isEmpty() ? NO_EXCLUSIVE_RESOURCES : new DefaultExclusiveResourceCollector(annotations);
    }

    private static class DefaultExclusiveResourceCollector
    extends ExclusiveResourceCollector {
        private final List<ResourceLock> annotations;
        private List<ResourceLocksProvider> providers;

        DefaultExclusiveResourceCollector(List<ResourceLock> annotations) {
            this.annotations = annotations;
        }

        @Override
        Stream<ExclusiveResource> getStaticResourcesFor(ResourceLockTarget target) {
            return this.annotations.stream().filter(annotation -> StringUtils.isNotBlank(annotation.value())).filter(annotation -> annotation.target() == target).map(annotation -> new ExclusiveResource(annotation.value(), DefaultExclusiveResourceCollector.toLockMode(annotation.mode())));
        }

        @Override
        Stream<ExclusiveResource> getDynamicResources(Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> providerToLocks) {
            List<ResourceLocksProvider> providers = this.getProviders();
            if (providers.isEmpty()) {
                return Stream.empty();
            }
            return providers.stream().map(providerToLocks).flatMap(Collection::stream).map(lock -> new ExclusiveResource(lock.getKey(), DefaultExclusiveResourceCollector.toLockMode(lock.getAccessMode())));
        }

        private List<ResourceLocksProvider> getProviders() {
            if (this.providers == null) {
                this.providers = this.annotations.stream().flatMap(annotation -> Stream.of(annotation.providers()).map(x$0 -> (ResourceLocksProvider)ReflectionUtils.newInstance(x$0, new Object[0]))).collect(CollectionUtils.toUnmodifiableList());
            }
            return this.providers;
        }

        private static ExclusiveResource.LockMode toLockMode(ResourceAccessMode mode) {
            switch (mode) {
                case READ: {
                    return ExclusiveResource.LockMode.READ;
                }
                case READ_WRITE: {
                    return ExclusiveResource.LockMode.READ_WRITE;
                }
            }
            throw new JUnitException("Unknown ResourceAccessMode: " + mode);
        }
    }
}

