/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.execution.TestInstancesProvider;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.0")
public class JupiterEngineExecutionContext
implements EngineExecutionContext {
    private final State state;
    private boolean beforeAllCallbacksExecuted = false;
    private boolean beforeAllMethodsExecuted = false;

    public JupiterEngineExecutionContext(EngineExecutionListener executionListener, JupiterConfiguration configuration) {
        this(new State(executionListener, configuration));
    }

    private JupiterEngineExecutionContext(State state) {
        this.state = state;
    }

    public void close() throws Exception {
        ExtensionContext extensionContext = this.getExtensionContext();
        if (extensionContext instanceof AutoCloseable) {
            try {
                ((AutoCloseable)extensionContext).close();
            }
            catch (Exception e) {
                throw new JUnitException("Failed to close extension context", e);
            }
        }
    }

    public EngineExecutionListener getExecutionListener() {
        return this.state.executionListener;
    }

    public JupiterConfiguration getConfiguration() {
        return this.state.configuration;
    }

    public TestInstancesProvider getTestInstancesProvider() {
        return this.state.testInstancesProvider;
    }

    public MutableExtensionRegistry getExtensionRegistry() {
        return this.state.extensionRegistry;
    }

    public ExtensionContext getExtensionContext() {
        return this.state.extensionContext;
    }

    public ThrowableCollector getThrowableCollector() {
        return this.state.throwableCollector;
    }

    public void beforeAllCallbacksExecuted(boolean beforeAllCallbacksExecuted) {
        this.beforeAllCallbacksExecuted = beforeAllCallbacksExecuted;
    }

    public boolean beforeAllCallbacksExecuted() {
        return this.beforeAllCallbacksExecuted;
    }

    public void beforeAllMethodsExecuted(boolean beforeAllMethodsExecuted) {
        this.beforeAllMethodsExecuted = beforeAllMethodsExecuted;
    }

    public boolean beforeAllMethodsExecuted() {
        return this.beforeAllMethodsExecuted;
    }

    public Builder extend() {
        return new Builder(this.state);
    }

    private static final class State
    implements Cloneable {
        final EngineExecutionListener executionListener;
        final JupiterConfiguration configuration;
        TestInstancesProvider testInstancesProvider;
        MutableExtensionRegistry extensionRegistry;
        ExtensionContext extensionContext;
        ThrowableCollector throwableCollector;

        State(EngineExecutionListener executionListener, JupiterConfiguration configuration) {
            this.executionListener = executionListener;
            this.configuration = configuration;
        }

        public State clone() {
            try {
                return (State)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JUnitException("State could not be cloned", e);
            }
        }
    }

    public static class Builder {
        private State originalState;
        private State newState = null;

        private Builder(State originalState) {
            this.originalState = originalState;
        }

        public Builder withTestInstancesProvider(TestInstancesProvider testInstancesProvider) {
            this.newState().testInstancesProvider = testInstancesProvider;
            return this;
        }

        public Builder withExtensionRegistry(MutableExtensionRegistry extensionRegistry) {
            this.newState().extensionRegistry = extensionRegistry;
            return this;
        }

        public Builder withExtensionContext(ExtensionContext extensionContext) {
            this.newState().extensionContext = extensionContext;
            return this;
        }

        public Builder withThrowableCollector(ThrowableCollector throwableCollector) {
            this.newState().throwableCollector = throwableCollector;
            return this;
        }

        public JupiterEngineExecutionContext build() {
            if (this.newState != null) {
                this.originalState = this.newState;
                this.newState = null;
            }
            return new JupiterEngineExecutionContext(this.originalState);
        }

        private State newState() {
            if (this.newState == null) {
                this.newState = this.originalState.clone();
            }
            return this.newState;
        }
    }
}

