/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestTemplateInvocationTestDescriptor
extends TestMethodTestDescriptor {
    public static final String SEGMENT_TYPE = "test-template-invocation";
    private TestTemplateInvocationContext invocationContext;
    private final int index;

    TestTemplateInvocationTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod, TestTemplateInvocationContext invocationContext, int index, JupiterConfiguration configuration) {
        super(uniqueId, invocationContext.getDisplayName(index), testClass, templateMethod, configuration);
        this.invocationContext = invocationContext;
        this.index = index;
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        return Collections.emptySet();
    }

    @Override
    public String getLegacyReportingName() {
        return super.getLegacyReportingName() + "[" + this.index + "]";
    }

    @Override
    protected ExtensionRegistry populateNewExtensionRegistry(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = super.populateNewExtensionRegistry(context);
        this.invocationContext.getAdditionalExtensions().forEach(extension -> registry.registerExtension((Extension)extension, this.invocationContext));
        return registry;
    }

    @Override
    public void after(JupiterEngineExecutionContext context) {
        this.invocationContext = null;
    }
}

