/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.experimental.categories.Category;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.runner.Description;

@API(status=API.Status.INTERNAL, since="4.12")
public class VintageTestDescriptor
extends AbstractTestDescriptor {
    public static final String ENGINE_ID = "junit-vintage";
    public static final String SEGMENT_TYPE_RUNNER = "runner";
    public static final String SEGMENT_TYPE_TEST = "test";
    public static final String SEGMENT_TYPE_DYNAMIC = "dynamic";
    protected Description description;

    public VintageTestDescriptor(UniqueId uniqueId, Description description, TestSource source) {
        this(uniqueId, description, VintageTestDescriptor.generateDisplayName(description), source);
    }

    VintageTestDescriptor(UniqueId uniqueId, Description description, String displayName, TestSource source) {
        super(uniqueId, displayName, source);
        this.description = description;
    }

    private static String generateDisplayName(Description description) {
        return description.getMethodName() != null ? description.getMethodName() : description.getDisplayName();
    }

    public Description getDescription() {
        return this.description;
    }

    @Override
    public String getLegacyReportingName() {
        String className;
        String methodName = this.description.getMethodName();
        if (methodName == null && StringUtils.isNotBlank(className = this.description.getClassName())) {
            return className;
        }
        return super.getLegacyReportingName();
    }

    @Override
    public TestDescriptor.Type getType() {
        return this.description.isTest() ? TestDescriptor.Type.TEST : TestDescriptor.Type.CONTAINER;
    }

    @Override
    public Set<TestTag> getTags() {
        LinkedHashSet<TestTag> tags = new LinkedHashSet<TestTag>();
        this.addTagsFromParent(tags);
        this.addCategoriesAsTags(tags);
        return tags;
    }

    @Override
    public void removeFromHierarchy() {
        if (this.canBeRemovedFromHierarchy()) {
            super.removeFromHierarchy();
        }
    }

    protected boolean canBeRemovedFromHierarchy() {
        return this.tryToExcludeFromRunner(this.description);
    }

    protected boolean tryToExcludeFromRunner(Description description) {
        return this.getParent().map(VintageTestDescriptor.class::cast).map(parent -> parent.tryToExcludeFromRunner(description)).orElse(false);
    }

    void pruneDescriptorsForObsoleteDescriptions(List<Description> newSiblingDescriptions) {
        Optional newDescription = newSiblingDescriptions.stream().filter(Predicate.isEqual(this.description)).findAny();
        if (newDescription.isPresent()) {
            ArrayList newChildren = ((Description)newDescription.get()).getChildren();
            new ArrayList(this.children).stream().map(VintageTestDescriptor.class::cast).forEach(childDescriptor -> childDescriptor.pruneDescriptorsForObsoleteDescriptions(newChildren));
        } else {
            super.removeFromHierarchy();
        }
    }

    private void addTagsFromParent(Set<TestTag> tags) {
        this.getParent().map(TestDescriptor::getTags).ifPresent(tags::addAll);
    }

    private void addCategoriesAsTags(Set<TestTag> tags) {
        Category annotation = (Category)this.description.getAnnotation(Category.class);
        if (annotation != null) {
            Arrays.stream(annotation.value()).map(ReflectionUtils::getAllAssignmentCompatibleClasses).flatMap(Collection::stream).distinct().map(Class::getName).map(TestTag::create).forEachOrdered(tags::add);
        }
    }
}

