/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

class EnumConfigurationParameterConverter<E extends Enum<E>> {
    private static final Logger logger = LoggerFactory.getLogger(EnumConfigurationParameterConverter.class);
    private final Class<E> enumType;
    private final String enumDisplayName;

    EnumConfigurationParameterConverter(Class<E> enumType, String enumDisplayName) {
        this.enumType = enumType;
        this.enumDisplayName = enumDisplayName;
    }

    E get(ConfigurationParameters configParams, String key, E defaultValue) {
        Preconditions.notNull(configParams, "ConfigurationParameters must not be null");
        Optional<String> optional = configParams.get(key);
        String constantName = null;
        if (optional.isPresent()) {
            try {
                constantName = optional.get().trim().toUpperCase();
                E value = Enum.valueOf(this.enumType, constantName);
                logger.info(() -> String.format("Using %s '%s' set via the '%s' configuration parameter.", this.enumDisplayName, value, key));
                return value;
            }
            catch (Exception ex) {
                String constant = constantName;
                logger.warn(() -> String.format("Invalid %s '%s' set via the '%s' configuration parameter. Falling back to the %s default value.", this.enumDisplayName, constant, key, defaultValue.name()));
            }
        }
        return defaultValue;
    }
}

