/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.tycho.surefire.osgibooter";
    private static PlatformAdmin platformAdmin;

    public void start(BundleContext context) throws Exception {
        ServiceReference platformAdminRef = context.getServiceReference(PlatformAdmin.class.getName());
        if (platformAdminRef != null) {
            platformAdmin = (PlatformAdmin)context.getService(platformAdminRef);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    public static Bundle getBundle(String symbolicName) {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle == null) {
            return null;
        }
        if (Platform.isFragment((Bundle)bundle)) {
            Bundle[] hosts = Platform.getHosts((Bundle)bundle);
            if (hosts != null && hosts.length > 0) {
                return hosts[0];
            }
            throw new IllegalArgumentException("Fragment bundle is not attached to a host " + symbolicName);
        }
        return bundle;
    }

    public static Set<ResolverError> getResolutionErrors(Bundle bundle) {
        LinkedHashSet<ResolverError> errors = new LinkedHashSet<ResolverError>();
        try {
            if (platformAdmin == null) {
                System.err.println("Could not compute diagnostic information for the test bundle resolution problems - PlatformAdmin service is not available");
                return errors;
            }
            State state = platformAdmin.getState(false);
            if (state == null) {
                System.err.println("Resolver state is null");
                return errors;
            }
            BundleDescription description = state.getBundle(bundle.getBundleId());
            if (description == null) {
                System.err.println("Could not determine BundleDescription for " + bundle.toString());
            }
            Activator.getRelevantErrors(state, errors, description);
        }
        catch (RuntimeException e) {
            System.err.println("Error while computing diagnostic information for the test bundle resolution problems");
            e.printStackTrace();
        }
        return errors;
    }

    private static void getRelevantErrors(State state, Set<ResolverError> errors, BundleDescription bundle) {
        ResolverError[] bundleErrors = state.getResolverErrors(bundle);
        int j = 0;
        while (j < bundleErrors.length) {
            ResolverError error = bundleErrors[j];
            errors.add(error);
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            if (constraint instanceof BundleSpecification || constraint instanceof HostSpecification) {
                BundleDescription[] requiredBundles = state.getBundles(constraint.getName());
                int i = 0;
                while (i < requiredBundles.length) {
                    Activator.getRelevantErrors(state, errors, requiredBundles[i]);
                    ++i;
                }
            }
            ++j;
        }
    }
}

