/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedClassLoader
extends ClassLoader {
    private ClassLoader[] loaders;

    public CombinedClassLoader(ClassLoader ... loaders) {
        this.loaders = loaders;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassLoader[] classLoaderArray = this.loaders;
        int n = this.loaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader loader = classLoaderArray[n2];
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n2;
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        ClassLoader[] classLoaderArray = this.loaders;
        int n = this.loaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader loader = classLoaderArray[n2];
            Enumeration<URL> resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                result.add(resources.nextElement());
            }
            ++n2;
        }
        return Collections.enumeration(result);
    }

    @Override
    protected URL findResource(String name) {
        URL url = null;
        ClassLoader[] classLoaderArray = this.loaders;
        int n = this.loaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader loader = classLoaderArray[n2];
            url = loader.getResource(name);
            if (url != null) {
                return url;
            }
            ++n2;
        }
        return null;
    }
}

