/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.tycho.surefire.osgibooter.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

class SurefireLoader
extends URLClassLoader
implements BundleReference {
    private Bundle testBundle;
    private ClassLoader delegate;

    SurefireLoader(List<URL> urls, BundleClassLoader delegate) {
        super(urls.toArray(new URL[urls.size()]));
        this.delegate = delegate;
    }

    public Bundle getBundle() {
        return this.testBundle;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if ("org.apache.maven.surefire.testng.utils.GroupMatcherMethodSelector".equals(name)) {
            return this.delegate.loadClass(name);
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return this.delegate.loadClass(name);
            }
            catch (ClassNotFoundException delegate) {
                e.addSuppressed(delegate);
                throw e;
            }
        }
    }

    @Override
    public URL findResource(String name) {
        URL resource = super.findResource(name);
        if (resource == null) {
            return this.delegate.getResource(name);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        final Enumeration<URL> resources = super.findResources(name);
        final Enumeration<URL> resources2 = this.delegate.getResources(name);
        return new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                if (resources.hasMoreElements()) {
                    return (URL)resources.nextElement();
                }
                if (resources2.hasMoreElements()) {
                    return (URL)resources2.nextElement();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return resources.hasMoreElements() || resources2.hasMoreElements();
            }
        };
    }
}

