/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.helper;

import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=PluginRealmHelper.class)
public class PluginRealmHelper {
    @Requirement
    private Logger logger;
    @Requirement
    private MavenPluginManager pluginManager;
    @Requirement
    private BuildPluginManager buildPluginManager;
    @Requirement
    private PluginDescriptorCache pluginDescriptorCache;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;
    @Requirement
    protected MavenPluginManager mavenPluginManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenSession session, MavenProject project, Runnable runnable, PluginFilter filter) throws PluginVersionResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException, PluginResolutionException, PluginManagerException {
        Objects.requireNonNull(session);
        MavenSession executeSession = session.clone();
        executeSession.setCurrentProject(project);
        for (Plugin plugin : project.getBuildPlugins()) {
            ClassRealm pluginRealm;
            PluginDescriptor pluginDescriptor;
            if (plugin.isExtensions()) continue;
            this.lifecyclePluginResolver.resolveMissingPluginVersions(project, executeSession);
            try {
                pluginDescriptor = this.mavenPluginManager.getPluginDescriptor(plugin, project.getRemotePluginRepositories(), executeSession.getRepositorySession());
            }
            catch (PluginResolutionException e) {
                this.logger.debug("PluginResolutionException while looking for components from " + plugin, (Throwable)e);
                continue;
            }
            if (pluginDescriptor == null || filter != null && !filter.accept(pluginDescriptor) || (pluginRealm = this.buildPluginManager.getPluginRealm(executeSession, pluginDescriptor)) == null) continue;
            ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
                runnable.run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(origTCCL);
            }
        }
    }

    public static interface PluginFilter {
        public boolean accept(PluginDescriptor var1);
    }
}

