/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.tycho.p2maven.InstallableUnitProvider;
import org.eclipse.tycho.p2maven.InstallableUnitPublisher;
import org.eclipse.tycho.p2maven.actions.AuthoredIUAction;
import org.eclipse.tycho.p2maven.actions.CategoryDependenciesAction;
import org.eclipse.tycho.p2maven.actions.FeatureDependenciesAction;
import org.eclipse.tycho.p2maven.actions.ProductDependenciesAction;
import org.eclipse.tycho.p2maven.actions.ProductFile2;
import org.eclipse.tycho.p2maven.helper.PluginRealmHelper;
import org.eclipse.tycho.p2maven.io.MetadataIO;
import org.xml.sax.SAXException;

@Component(role=InstallableUnitGenerator.class)
public class InstallableUnitGenerator {
    private static final boolean DUMP_DATA = Boolean.getBoolean("tycho.p2.dump") || Boolean.getBoolean("tycho.p2.dump.units");
    @Requirement
    private Logger log;
    private static final String KEY_UNITS = "InstallableUnitGenerator.units";
    @Requirement
    private IProvisioningAgent provisioningAgent;
    @Requirement(role=InstallableUnitProvider.class)
    private Map<String, InstallableUnitProvider> additionalUnitProviders;
    @Requirement
    private PluginRealmHelper pluginRealmHelper;
    @Requirement
    private InstallableUnitPublisher publisher;
    @Requirement
    private PlexusContainer plexus;

    public Map<MavenProject, Collection<IInstallableUnit>> getInstallableUnits(Collection<MavenProject> projects, MavenSession session) throws CoreException {
        this.init();
        Objects.requireNonNull(session);
        CopyOnWriteArrayList errors = new CopyOnWriteArrayList();
        ConcurrentHashMap<MavenProject, Collection<IInstallableUnit>> result = new ConcurrentHashMap<MavenProject, Collection<IInstallableUnit>>();
        ((Stream)projects.parallelStream().unordered()).takeWhile(nil -> errors.isEmpty()).forEach(project -> {
            try {
                result.put((MavenProject)project, this.getInstallableUnits((MavenProject)project, session, false));
            }
            catch (CoreException e) {
                errors.add(e);
            }
        });
        if (errors.isEmpty()) {
            return result;
        }
        if (errors.size() == 1) {
            throw (CoreException)((Object)errors.get(0));
        }
        MultiStatus multiStatus = new MultiStatus(InstallableUnitGenerator.class, 4, "computing installable unit units failed");
        errors.forEach(e -> multiStatus.add(e.getStatus()));
        throw new CoreException((IStatus)multiStatus);
    }

    private void init() {
        this.provisioningAgent.getService(IArtifactRepositoryManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session, boolean forceUpdate) throws CoreException {
        this.init();
        Objects.requireNonNull(session);
        this.log.debug("Computing installable units for " + project + ", force update = " + forceUpdate);
        MavenProject mavenProject = project;
        synchronized (mavenProject) {
            String packaging;
            Object contextValue;
            if (!forceUpdate && (contextValue = project.getContextValue(KEY_UNITS)) instanceof Collection) {
                Collection collection = (Collection)contextValue;
                if (InstallableUnitGenerator.isCompatible(collection)) {
                    this.log.debug("Using cached value for " + project);
                    return collection;
                }
                this.log.debug("Can't use cached value for " + project + " because of incompatible classloaders, update is forced!");
            }
            ArrayList<Object> actions = new ArrayList<Object>();
            File basedir = project.getBasedir();
            if (basedir == null || !basedir.isDirectory()) {
                this.log.warn("No valid basedir for " + project + "!");
                return Collections.emptyList();
            }
            switch (packaging = project.getPackaging()) {
                case "eclipse-test-plugin": 
                case "eclipse-plugin": {
                    actions.add(new BundlesAction(new File[]{basedir}));
                    break;
                }
                case "eclipse-feature": {
                    FeatureParser parser = new FeatureParser();
                    Feature feature = parser.parse(basedir);
                    feature.setLocation(basedir.getAbsolutePath());
                    FeatureDependenciesAction action = new FeatureDependenciesAction(feature);
                    actions.add((Object)action);
                    break;
                }
                case "eclipse-repository": {
                    File categoryFile = new File(basedir, "category.xml");
                    if (categoryFile.exists()) {
                        try (FileInputStream stream = new FileInputStream(categoryFile);){
                            SiteModel siteModel = new CategoryParser(null).parse((InputStream)stream);
                            actions.add((Object)new CategoryDependenciesAction(siteModel, project.getArtifactId(), project.getVersion()));
                        }
                        catch (IOException | SAXException e) {
                            throw new CoreException(Status.error((String)("Error reading " + categoryFile.getAbsolutePath())));
                        }
                    }
                    for (File f : basedir.listFiles(File::isFile)) {
                        if (!f.getName().endsWith(".product") || f.getName().startsWith(".polyglot")) continue;
                        try {
                            ProductFile2 productDescriptor = new ProductFile2(f.getAbsolutePath());
                            actions.add((Object)new ProductDependenciesAction((IProductDescriptor)productDescriptor));
                        }
                        catch (CoreException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new CoreException(Status.error((String)("Error reading " + f.getAbsolutePath() + ": " + e), (Throwable)e));
                        }
                    }
                    break;
                }
                case "p2-installable-unit": {
                    actions.add((Object)new AuthoredIUAction(basedir));
                    break;
                }
            }
            Collection<IInstallableUnit> publishedUnits = this.publisher.publishMetadata(actions);
            for (InstallableUnitProvider unitProvider : this.getProvider(project, session)) {
                this.log.debug("Asking: " + unitProvider + " for additional units for " + project + "...");
                Collection<IInstallableUnit> installableUnits = unitProvider.getInstallableUnits(project, session);
                this.log.debug("Provider " + unitProvider + " generated " + installableUnits.size() + " (" + installableUnits + ") units for " + project);
                publishedUnits.addAll(installableUnits);
            }
            Collection<IInstallableUnit> result = Collections.unmodifiableCollection(publishedUnits);
            if (DUMP_DATA) {
                File file = new File(project.getBasedir(), "project-units.xml");
                try {
                    new MetadataIO().writeXML(result, file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (result.isEmpty()) {
                this.log.debug("Can't generate any InstallableUnit for packaging type '" + packaging + "' for " + project);
            }
            project.setContextValue(KEY_UNITS, result);
            return result;
        }
    }

    private Collection<InstallableUnitProvider> getProvider(MavenProject project, MavenSession mavenSession) throws CoreException {
        HashSet<InstallableUnitProvider> unitProviders = new HashSet<InstallableUnitProvider>(this.additionalUnitProviders.values());
        try {
            this.pluginRealmHelper.execute(mavenSession, project, () -> {
                try {
                    for (InstallableUnitProvider provider : this.plexus.lookupList(InstallableUnitProvider.class)) {
                        unitProviders.add(provider);
                    }
                }
                catch (ComponentLookupException componentLookupException) {
                    // empty catch block
                }
            }, InstallableUnitGenerator::hasPluginDependency);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)"Can't lookup InstallableUnitProviders", (Throwable)e));
        }
        return unitProviders;
    }

    private static boolean isCompatible(Collection<?> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        for (Object unit : collection) {
            if (IInstallableUnit.class.isInstance(unit)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasPluginDependency(PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor.getArtifactMap().containsKey("org.eclipse.tycho:p2-maven-plugin")) {
            return true;
        }
        return pluginDescriptor.getDependencies().stream().filter(dep -> "org.eclipse.tycho".equals(dep.getGroupId())).filter(dep -> "p2-maven-plugin".equals(dep.getArtifactId())).findAny().isPresent();
    }
}

