/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.tycho.ArtifactDescriptor;

public class DependencyChain {
    private ArtifactDescriptor root;
    private Collection<ArtifactDescriptor> artifacts;

    public DependencyChain(ArtifactDescriptor root, Collection<ArtifactDescriptor> artifacts) {
        this.root = root;
        this.artifacts = artifacts;
    }

    public List<ArtifactDescriptor> pathToRoot(ArtifactDescriptor from) {
        HashSet<ArtifactDescriptor> visited = new HashSet<ArtifactDescriptor>();
        ArrayDeque<Edge> queue = new ArrayDeque<Edge>();
        queue.add(new Edge(this.root, null, null));
        while (!queue.isEmpty()) {
            Edge current = (Edge)queue.remove();
            if (!visited.add(current.value)) continue;
            for (Edge edge : this.getDepends(current)) {
                if (edge.value == from) {
                    return this.toList(edge);
                }
                queue.add(edge);
            }
        }
        return Collections.emptyList();
    }

    private List<ArtifactDescriptor> toList(Edge edge) {
        ArrayList<ArtifactDescriptor> list = new ArrayList<ArtifactDescriptor>();
        while (edge != null) {
            list.add(edge.value);
            edge = edge.parent;
        }
        Collections.reverse(list);
        return list;
    }

    private List<Edge> getDepends(Edge edge) {
        List<IRequirement> list = this.requirementsOf(edge.value);
        ArrayList<Edge> candidates = new ArrayList<Edge>(32);
        block0: for (ArtifactDescriptor other : this.artifacts) {
            for (IRequirement requirement : list) {
                if (!this.satisfies(other, requirement)) continue;
                candidates.add(new Edge(other, requirement, edge));
                continue block0;
            }
        }
        return candidates;
    }

    private List<IRequirement> requirementsOf(ArtifactDescriptor descriptor) {
        return descriptor.getInstallableUnits().stream().flatMap(iu -> Stream.concat(iu.getRequirements().stream(), iu.getMetaRequirements().stream())).distinct().toList();
    }

    private boolean satisfies(ArtifactDescriptor descriptor, IRequirement requirement) {
        return descriptor.getInstallableUnits().stream().anyMatch(iu -> iu.satisfies(requirement));
    }

    private record Edge(ArtifactDescriptor value, IRequirement requirement, Edge parent) {
    }
}

