/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.p2maven.ListQueryable;
import org.eclipse.tycho.p2maven.LoggerProgressMonitor;

@Component(role=P2RepositoryManager.class)
public class P2RepositoryManager {
    @Requirement
    IRepositoryIdManager repositoryIdManager;
    @Requirement
    IProvisioningAgent agent;
    @Requirement
    Logger logger;

    public IArtifactRepository getArtifactRepository(Repository repository) throws URISyntaxException, ProvisionException {
        return this.getArtifactRepository(new URI(repository.getUrl()), repository.getId());
    }

    public IArtifactRepository getArtifactRepository(MavenRepositoryLocation repository) throws ProvisionException {
        return this.getArtifactRepository(repository.getURL(), repository.getId());
    }

    public IArtifactRepository getCompositeArtifactRepository(Collection<Repository> repositories) throws ProvisionException, URISyntaxException {
        if (repositories.size() == 1) {
            return this.getArtifactRepository(repositories.iterator().next());
        }
        ArrayList<IArtifactRepository> childs = new ArrayList<IArtifactRepository>();
        for (Repository repository : repositories) {
            childs.add(this.getArtifactRepository(repository));
        }
        return new ListCompositeArtifactRepository(this.agent, childs);
    }

    public IMetadataRepository getMetadataRepository(Repository repository) throws URISyntaxException, ProvisionException {
        return this.getMetadataRepositor(new URI(repository.getUrl()), repository.getId());
    }

    public IQueryable<IInstallableUnit> getCompositeMetadataRepository(Collection<Repository> repositories) throws ProvisionException, URISyntaxException {
        if (repositories.size() == 1) {
            return this.getMetadataRepository(repositories.iterator().next());
        }
        ListQueryable<IInstallableUnit> queryable = new ListQueryable<IInstallableUnit>();
        for (Repository repository : repositories) {
            queryable.add((IQueryable<IInstallableUnit>)this.getMetadataRepository(repository));
        }
        return queryable;
    }

    public IMetadataRepository getMetadataRepositor(MavenRepositoryLocation repository) throws ProvisionException {
        return this.getMetadataRepositor(repository.getURL(), repository.getId());
    }

    private IArtifactRepository getArtifactRepository(URI location, String id) throws ProvisionException {
        this.repositoryIdManager.addMapping(id, location);
        IArtifactRepositoryManager repositoryManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
        return repositoryManager.loadRepository(location, (IProgressMonitor)new LoggerProgressMonitor(this.logger));
    }

    private IMetadataRepository getMetadataRepositor(URI location, String id) throws ProvisionException {
        this.repositoryIdManager.addMapping(id, location);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        return metadataManager.loadRepository(location, (IProgressMonitor)new LoggerProgressMonitor(this.logger));
    }

    public void downloadArtifact(IInstallableUnit iu, IArtifactRepository artifactRepository, OutputStream outputStream) throws IOException {
        Collection artifacts = iu.getArtifacts();
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            int n = 0;
            IArtifactKey key = (IArtifactKey)iterator.next();
            IArtifactDescriptor[] descriptors = artifactRepository.getArtifactDescriptors(key);
            IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
            int n2 = iArtifactDescriptorArray.length;
            if (n >= n2) continue;
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n];
            IStatus status = artifactRepository.getRawArtifact(descriptor, outputStream, (IProgressMonitor)new LoggerProgressMonitor(this.logger));
            if (status.isOK()) {
                return;
            }
            throw new IOException("Download failed: " + status);
        }
        throw new FileNotFoundException();
    }
}

