/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.p2maven.helper.ProxyHelper;
import org.eclipse.tycho.p2maven.transport.HttpTransport;
import org.eclipse.tycho.p2maven.transport.HttpTransportFactory;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;
import org.eclipse.tycho.p2maven.transport.Response;

@Component(role=HttpTransportFactory.class, hint="JavaUrl")
public class URLHttpTransportFactory
implements HttpTransportFactory {
    static final String HINT = "JavaUrl";
    @Requirement
    ProxyHelper proxyHelper;
    @Requirement
    MavenAuthenticator authenticator;

    @Override
    public HttpTransport createTransport(URI uri) {
        URLHttpTransport transport = new URLHttpTransport(uri, this.proxyHelper, this.authenticator);
        return transport;
    }

    private static final class URLHttpTransport
    implements HttpTransport {
        private URI uri;
        private ProxyHelper proxyHelper;
        private MavenAuthenticator authenticator;
        private Map<String, String> extraHeaders = new HashMap<String, String>();

        public URLHttpTransport(URI uri, ProxyHelper proxyHelper, MavenAuthenticator authenticator) {
            this.uri = uri;
            this.proxyHelper = proxyHelper;
            this.authenticator = authenticator;
        }

        @Override
        public void setHeader(String key, String value) {
            this.extraHeaders.put(key, value);
        }

        @Override
        public Response<InputStream> get() throws IOException {
            final HttpURLConnection connection = this.createConnection();
            connection.connect();
            return new HttpResponse<InputStream>(connection){

                @Override
                public void close() {
                    try (InputStream stream = this.anyBody();){
                        for (int i = 0; i < 10240; ++i) {
                            int read = stream.read();
                            if (read >= 0) continue;
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private InputStream anyBody() throws IOException {
                    InputStream errorStream = connection.getErrorStream();
                    if (errorStream != null) {
                        return errorStream;
                    }
                    return connection.getInputStream();
                }

                @Override
                public InputStream body() throws IOException {
                    return connection.getInputStream();
                }
            };
        }

        private HttpURLConnection createConnection() throws IOException, MalformedURLException {
            HttpURLConnection connection = (HttpURLConnection)this.uri.toURL().openConnection(this.proxyHelper.getProxy(this.uri));
            connection.setAuthenticator(this.authenticator);
            connection.setInstanceFollowRedirects(false);
            this.authenticator.preemtiveAuth((k, v) -> connection.setRequestProperty((String)k, (String)v), this.uri);
            this.extraHeaders.forEach(connection::setRequestProperty);
            return connection;
        }

        @Override
        public Response<Void> head() throws IOException {
            HttpURLConnection connection = this.createConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            return new HttpResponse<Void>(connection){

                @Override
                public void close() {
                }

                @Override
                public Void body() throws IOException {
                    return null;
                }
            };
        }
    }

    private static abstract class HttpResponse<T>
    implements Response<T> {
        private HttpURLConnection connection;

        HttpResponse(HttpURLConnection connection) {
            this.connection = connection;
        }

        @Override
        public int statusCode() throws IOException {
            return this.connection.getResponseCode();
        }

        @Override
        public Map<String, List<String>> headers() {
            return this.connection.getHeaderFields();
        }

        @Override
        public String getHeader(String header) {
            return this.connection.getHeaderField(header);
        }

        @Override
        public long getLastModified() {
            return this.connection.getLastModified();
        }

        @Override
        public URI getURI() {
            try {
                return this.connection.getURL().toURI();
            }
            catch (URISyntaxException e) {
                throw new AssertionError("Should never happen!", e);
            }
        }
    }
}

