/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.repository;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.p2maven.helper.SettingsDecrypterHelper;

@Component(role=MavenRepositorySettings.class)
public class DefaultMavenRepositorySettings
implements MavenRepositorySettings,
Initializable {
    private static final ArtifactRepositoryPolicy P2_REPOSITORY_POLICY = new ArtifactRepositoryPolicy(true, "never", "ignore");
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private SettingsDecrypterHelper decrypter;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement(hint="p2")
    private ArtifactRepositoryLayout p2layout;
    private Map<String, URI> idToMirrorMap = new HashMap<String, URI>();
    private Settings settings;
    private List<Mirror> mirrors;

    public DefaultMavenRepositorySettings() {
    }

    public DefaultMavenRepositorySettings(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public MavenRepositoryLocation getMirror(MavenRepositoryLocation location) {
        if (location.getId() == null) {
            return null;
        }
        if (this.idToMirrorMap.containsKey(location.getId())) {
            return new MavenRepositoryLocation(location.getId(), this.idToMirrorMap.get(location.getId()));
        }
        ArtifactRepository locationAsMavenRepository = this.repositorySystem.createArtifactRepository(location.getId(), location.getURL().toString(), this.p2layout, P2_REPOSITORY_POLICY, P2_REPOSITORY_POLICY);
        Mirror mirror = this.getTychoMirror(locationAsMavenRepository, this.mirrors);
        if (mirror != null) {
            return new MavenRepositoryLocation(mirror.getId(), URI.create(mirror.getUrl()));
        }
        return null;
    }

    public MavenRepositorySettings.Credentials getCredentials(MavenRepositoryLocation location) {
        if (location.getId() == null) {
            return null;
        }
        Server serverSettings = this.settings.getServer(location.getId());
        if (serverSettings != null) {
            SettingsDecryptionResult result = this.decrypter.decryptAndLogProblems(serverSettings);
            Server decryptedServer = result.getServer();
            return new MavenRepositorySettings.Credentials(decryptedServer.getUsername(), decryptedServer.getPassword(), location.getURL());
        }
        return null;
    }

    public Mirror getTychoMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        Mirror mavenMirror = this.repositorySystem.getMirror(repository, mirrors);
        if (mavenMirror != null || mirrors == null) {
            return mavenMirror;
        }
        for (Mirror mirror : mirrors) {
            if (!DefaultMavenRepositorySettings.isPrefixMirrorOf(repository, mirror)) continue;
            return DefaultMavenRepositorySettings.createMirror(repository, mirror);
        }
        return null;
    }

    private static boolean isPrefixMirrorOf(ArtifactRepository repo, Mirror mirror) {
        boolean isMirrorOfRepoUrl = repo.getUrl() != null && repo.getUrl().startsWith(mirror.getMirrorOf());
        boolean matchesLayout = repo.getLayout() != null && repo.getLayout().getId().equals(mirror.getMirrorOfLayouts());
        return isMirrorOfRepoUrl && matchesLayout;
    }

    private static Mirror createMirror(ArtifactRepository repo, Mirror toMirror) {
        Mirror mirror = toMirror.clone();
        String urlToReplace = toMirror.getMirrorOf();
        String newUrl = StringUtils.replaceOnce((String)repo.getUrl(), (String)urlToReplace, (String)toMirror.getUrl());
        mirror.setUrl(newUrl);
        mirror.setId(toMirror.getId());
        return mirror;
    }

    public void addMirror(String repositoryId, URI mirroredUrl) {
        if (mirroredUrl == null) {
            this.idToMirrorMap.remove(repositoryId);
        } else {
            this.idToMirrorMap.put(repositoryId, mirroredUrl);
        }
    }

    public void initialize() throws InitializationException {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            this.settings = session.getSettings();
            this.mirrors = session.getRequest().getMirrors();
        } else {
            this.settings = new Settings();
            this.mirrors = Collections.emptyList();
        }
    }
}

