/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.helper;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.tycho.p2maven.helper.SettingsDecrypterHelper;

@Component(role=ProxyHelper.class)
public class ProxyHelper
implements Initializable {
    @Requirement
    protected Logger logger;
    @Requirement
    protected LegacySupport context;
    @Requirement
    protected SettingsDecrypterHelper decrypter;
    private RepositorySystemSession repositorySession;

    public void initialize() throws InitializationException {
        MavenSession session = this.context.getSession();
        if (session != null) {
            this.repositorySession = session.getRepositorySession();
        }
    }

    public java.net.Proxy getProxy(URI uri) {
        if (this.repositorySession != null) {
            RemoteRepository repository = new RemoteRepository.Builder(null, "p2", uri.toASCIIString()).build();
            Proxy mavenProxy = this.repositorySession.getProxySelector().getProxy(repository);
            if (mavenProxy != null) {
                return new java.net.Proxy(ProxyHelper.convertType(mavenProxy.getType()), new InetSocketAddress(mavenProxy.getHost(), mavenProxy.getPort()));
            }
        }
        return java.net.Proxy.NO_PROXY;
    }

    private static Proxy.Type convertType(String type) {
        if ("http".equalsIgnoreCase(type)) {
            return Proxy.Type.HTTP;
        }
        return Proxy.Type.SOCKS;
    }

    public PasswordAuthentication getPasswordAuthentication(URI uri, Authenticator.RequestorType type) {
        if (this.repositorySession != null) {
            Authentication authentication;
            RemoteRepository repository = new RemoteRepository.Builder(null, "p2", uri.toASCIIString()).build();
            Proxy mavenProxy = this.repositorySession.getProxySelector().getProxy(repository);
            if (mavenProxy != null && (authentication = mavenProxy.getAuthentication()) != null) {
                RemoteRepository repo = new RemoteRepository.Builder(repository).setProxy(mavenProxy).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy((RepositorySystemSession)this.repositorySession, (RemoteRepository)repo);
                String password = authCtx.get("password");
                return new PasswordAuthentication(authCtx.get("username"), password == null ? new char[]{} : password.toCharArray());
            }
        }
        return null;
    }
}

