/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

public interface Response<T>
extends AutoCloseable {
    public int statusCode() throws IOException;

    public Map<String, List<String>> headers();

    @Override
    public void close();

    public T body() throws IOException;

    public URI getURI();

    public String getHeader(String var1);

    public long getLastModified();

    default public void checkResponseCode() throws FileNotFoundException, IOException {
        int code = this.statusCode();
        if (code >= 400) {
            if (code == 404 || code == 410) {
                throw new FileNotFoundException(this.getURI().toString());
            }
            throw new IOException("Server returned HTTP code: " + code + " for URL " + this.getURI().toString());
        }
    }
}

