/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.tycho.p2maven.transport.DownloadStatusOutputStream;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;
import org.eclipse.tycho.p2maven.transport.TransportProtocolHandler;

@Component(role=Transport.class, hint="tycho")
public class TychoRepositoryTransport
extends Transport
implements IAgentServiceFactory {
    private static final int MAX_DOWNLOAD_THREADS = Integer.getInteger("tycho.p2.transport.max-download-threads", 4);
    private static final boolean DEBUG_REQUESTS = Boolean.getBoolean("tycho.p2.transport.debug");
    private static final Executor DOWNLOAD_EXECUTOR = Executors.newFixedThreadPool(MAX_DOWNLOAD_THREADS, new ThreadFactory(){
        private AtomicInteger cnt = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("Tycho-Download-Thread-" + this.cnt.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    @Requirement
    Logger logger;
    @Requirement
    TransportCacheConfig cacheConfig;
    @Requirement(role=TransportProtocolHandler.class)
    Map<String, TransportProtocolHandler> transportProtocolHandlers;
    private LongAdder requests = new LongAdder();
    private LongAdder indexRequests = new LongAdder();

    public TychoRepositoryTransport() {
        this.numberFormat.setMaximumFractionDigits(2);
    }

    public IStatus download(URI toDownload, OutputStream target, long startPos, IProgressMonitor monitor) {
        if (startPos > 0L) {
            return new Status(4, TychoRepositoryTransport.class.getName(), "range downloads are not implemented");
        }
        return this.download(toDownload, target, monitor);
    }

    public IStatus download(URI toDownload, OutputStream target, IProgressMonitor monitor) {
        String id = "p2";
        if (this.cacheConfig.isInteractive()) {
            this.logger.info("Downloading from " + id + ": " + toDownload);
        }
        try {
            DownloadStatusOutputStream statusOutputStream = new DownloadStatusOutputStream(target, "Download of " + toDownload);
            this.stream(toDownload, monitor).transferTo(statusOutputStream);
            DownloadStatus downloadStatus = statusOutputStream.getStatus();
            if (this.cacheConfig.isInteractive()) {
                this.logger.info("Downloaded from " + id + ": " + toDownload + " (" + FileUtils.byteCountToDisplaySize((long)downloadStatus.getFileSize()) + " at " + FileUtils.byteCountToDisplaySize((long)downloadStatus.getTransferRate()) + "/s)");
            }
            return this.reportStatus((IStatus)downloadStatus, target);
        }
        catch (AuthenticationFailedException e) {
            return new Status(4, TychoRepositoryTransport.class.getName(), "authentication failed for " + toDownload, (Throwable)e);
        }
        catch (IOException e) {
            return this.reportStatus((IStatus)new Status(4, TychoRepositoryTransport.class.getName(), "download from " + toDownload + " failed", (Throwable)e), target);
        }
        catch (CoreException e) {
            return this.reportStatus(e.getStatus(), target);
        }
    }

    private IStatus reportStatus(IStatus status, OutputStream target) {
        if (target instanceof IStateful) {
            IStateful stateful = (IStateful)target;
            stateful.setStatus(status);
        }
        return status;
    }

    public InputStream stream(URI toDownload, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
        if (DEBUG_REQUESTS) {
            this.logger.debug("Request stream for " + toDownload);
        }
        this.requests.increment();
        if (toDownload.toASCIIString().endsWith("p2.index")) {
            this.indexRequests.increment();
        }
        try {
            Object cachedFile;
            TransportProtocolHandler handler = this.getHandler(toDownload);
            if (handler != null && (cachedFile = handler.getFile(toDownload)) != null) {
                if (DEBUG_REQUESTS) {
                    this.logger.debug(" --> routed through handler " + handler.getClass().getSimpleName());
                }
                FileInputStream fileInputStream = new FileInputStream((File)cachedFile);
                return fileInputStream;
            }
            cachedFile = toDownload.toURL().openStream();
            return cachedFile;
        }
        catch (FileNotFoundException e) {
            if (DEBUG_REQUESTS) {
                this.logger.debug(" --> not found!");
            }
            throw e;
        }
        catch (IOException e) {
            if (e instanceof AuthenticationFailedException) {
                AuthenticationFailedException afe = (AuthenticationFailedException)((Object)e);
                throw afe;
            }
            if (DEBUG_REQUESTS) {
                this.logger.debug(" --> generic error: " + e);
            }
            throw new CoreException((IStatus)new Status(4, TychoRepositoryTransport.class.getName(), "download from " + toDownload + " failed", (Throwable)e));
        }
        finally {
            if (DEBUG_REQUESTS) {
                this.logger.debug("Total number of requests: " + this.requests.longValue() + " (" + this.indexRequests.longValue() + " for p2.index)");
            }
        }
    }

    TransportProtocolHandler getHandler(URI uri) {
        String lc;
        TransportProtocolHandler handler;
        String scheme = uri.getScheme();
        if (scheme != null && (handler = this.transportProtocolHandlers.get(lc = scheme.toLowerCase())) != null) {
            return handler;
        }
        return null;
    }

    public long getLastModified(URI toDownload, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        try {
            TransportProtocolHandler handler = this.getHandler(toDownload);
            if (handler != null) {
                return handler.getLastModified(toDownload);
            }
            URLConnection connection = toDownload.toURL().openConnection();
            long lastModified = connection.getLastModified();
            connection.getInputStream().close();
            return lastModified;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, TychoRepositoryTransport.class.getName(), "download from " + toDownload + " failed", (Throwable)e));
        }
    }

    public Object createService(IProvisioningAgent agent) {
        return this;
    }

    public static Executor getDownloadExecutor() {
        return DOWNLOAD_EXECUTOR;
    }

    public File downloadToFile(URI uri) throws IOException {
        File file;
        TransportProtocolHandler handler = this.getHandler(uri);
        if (handler != null && (file = handler.getFile(uri)) != null) {
            return file;
        }
        Path tempFile = Files.createTempFile("tycho", ".tmp", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        try {
            Files.copy(this.stream(uri, null), tempFile, new CopyOption[0]);
            return tempFile.toFile();
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }
}

