/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryComponent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;
import org.eclipse.tycho.p2maven.transport.P2MirrorDisablingArtifactRepositoryManager;
import org.eclipse.tycho.p2maven.transport.RemoteArtifactRepositoryManager;
import org.eclipse.tycho.version.TychoVersion;

@Component(role=IAgentServiceFactory.class, hint="org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager")
public class RemoteArtifactRepositoryManagerAgentFactory
implements IAgentServiceFactory {
    @Requirement
    Logger logger;
    @Requirement
    IRepositoryIdManager repositoryIdManager;
    @Requirement
    MavenAuthenticator authenticator;
    @Requirement
    MavenSession mavenSession;

    public Object createService(IProvisioningAgent agent) {
        IArtifactRepositoryManager plainRepoManager = (IArtifactRepositoryManager)new ArtifactRepositoryComponent().createService(agent);
        if (this.getDisableP2MirrorsConfiguration()) {
            plainRepoManager = new P2MirrorDisablingArtifactRepositoryManager(plainRepoManager, this.logger);
        }
        return new RemoteArtifactRepositoryManager(plainRepoManager, this.repositoryIdManager, this.authenticator);
    }

    private boolean getDisableP2MirrorsConfiguration() {
        String deprecatedKey = "tycho.disableP2Mirrors";
        String deprecatedValue = this.getMirrorProperty(deprecatedKey);
        if (deprecatedValue != null) {
            this.logger.info("Using " + deprecatedKey + " to disable P2 mirrors is deprecated, use the property eclipse.p2.mirrors instead, see https://tycho.eclipseprojects.io/doc/" + TychoVersion.getTychoVersion() + "/SystemProperties.html for details.");
            return this.getBooleanValue(deprecatedValue);
        }
        String value = this.getMirrorProperty("eclipse.p2.mirrors");
        if (value != null) {
            boolean p2MirrorsEnabled = this.getBooleanValue(value);
            return !p2MirrorsEnabled;
        }
        return false;
    }

    private boolean getBooleanValue(String value) {
        if (value != null && value.isBlank()) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    private String getMirrorProperty(String key) {
        Properties userProperties = this.mavenSession.getUserProperties();
        String userProperty = userProperties.getProperty(key);
        if (userProperty != null) {
            return userProperty;
        }
        Settings settings = this.mavenSession.getSettings();
        List profiles = settings.getProfiles();
        List activeProfiles = settings.getActiveProfiles();
        for (Profile profile : profiles) {
            String profileProperty;
            if (!activeProfiles.contains(profile.getId()) || (profileProperty = profile.getProperties().getProperty(key)) == null) continue;
            return profileProperty;
        }
        Properties systemProperties = this.mavenSession.getSystemProperties();
        String systemProperty = systemProperties.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        return System.getProperty(key);
    }
}

