/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.EquinoxLaunchingException;
import org.eclipse.tycho.launching.LaunchConfiguration;

@Component(role=EquinoxLauncher.class)
public class DefaultEquinoxLauncher
implements EquinoxLauncher {
    @Requirement
    private Logger log;

    public int execute(LaunchConfiguration configuration, int forkedProcessTimeoutInSeconds) throws EquinoxLaunchingException {
        Commandline cli = new Commandline();
        String executable = configuration.getJvmExecutable();
        if (executable == null || "".equals(executable)) {
            executable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            if (File.separatorChar == '\\') {
                executable = executable + ".exe";
            }
        }
        cli.setExecutable(executable);
        cli.setWorkingDirectory(configuration.getWorkingDirectory());
        cli.addArguments(configuration.getVMArguments());
        cli.addArguments(new String[]{"-jar", this.getCanonicalPath(configuration.getLauncherJar())});
        cli.addArguments(configuration.getProgramArguments());
        for (Map.Entry var : configuration.getEnvironment().entrySet()) {
            cli.addEnvironment((String)var.getKey(), (String)var.getValue());
        }
        this.log.info("Command line:\n\t" + cli.toString());
        StreamConsumer out = new StreamConsumer(){

            public void consumeLine(String line) {
                System.out.println(line);
            }
        };
        StreamConsumer err = new StreamConsumer(){

            public void consumeLine(String line) {
                System.err.println(line);
            }
        };
        try {
            return CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err, (int)forkedProcessTimeoutInSeconds);
        }
        catch (CommandLineException e) {
            throw new EquinoxLaunchingException((Exception)((Object)e));
        }
    }

    private String getCanonicalPath(File file) throws EquinoxLaunchingException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new EquinoxLaunchingException(e);
        }
    }
}

