/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.tycho.launching.LaunchConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxInstallationLaunchConfiguration
implements LaunchConfiguration {
    private final File equinoxDirectory;
    private final String[] programArguments;
    private final File launcherJar;

    public EquinoxInstallationLaunchConfiguration(File equinoxDirectory, List<String> programArguments) {
        this.equinoxDirectory = equinoxDirectory;
        this.programArguments = programArguments.toArray(new String[0]);
        this.launcherJar = EquinoxInstallationLaunchConfiguration.findLauncherJar(equinoxDirectory);
    }

    private static File findLauncherJar(File equinoxDirectory) {
        File pluginsDir = new File(equinoxDirectory, "plugins");
        File[] launchers = pluginsDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("org.eclipse.equinox.launcher_");
            }
        });
        if (launchers.length == 0) {
            throw new IllegalArgumentException("No launcher bundle found in " + pluginsDir);
        }
        if (launchers.length > 1) {
            throw new IllegalArgumentException("Multiple versions of the launcher bundle found in " + pluginsDir);
        }
        return launchers[0];
    }

    public File getWorkingDirectory() {
        return this.equinoxDirectory;
    }

    public String getJvmExecutable() {
        return null;
    }

    public File getLauncherJar() {
        return this.launcherJar;
    }

    public String[] getVMArguments() {
        return new String[0];
    }

    public String[] getProgramArguments() {
        return this.programArguments;
    }

    public Map<String, String> getEnvironment() {
        return Collections.emptyMap();
    }
}

