/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.cli.Commandline;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.tycho.launching.LaunchConfiguration;

public class EquinoxLaunchConfiguration
implements LaunchConfiguration {
    private String jvmExecutable;
    private File workingDirectory;
    private final Map<String, String> env = new LinkedHashMap<String, String>();
    private final List<Commandline.Argument> args = new ArrayList<Commandline.Argument>();
    private final List<Commandline.Argument> vmargs = new ArrayList<Commandline.Argument>();
    private final EquinoxInstallation installation;

    public EquinoxLaunchConfiguration(EquinoxInstallation installation) {
        this.installation = installation;
    }

    public void addEnvironmentVariables(Map<String, String> variables) {
        Iterator<String> i$ = variables.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            String value = variables.get(key = i$.next());
            this.env.put(key, value != null ? value : "");
        }
    }

    public Map<String, String> getEnvironment() {
        return this.env;
    }

    public void setJvmExecutable(String jvmExecutable) {
        this.jvmExecutable = jvmExecutable;
    }

    public String getJvmExecutable() {
        return this.jvmExecutable;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void addProgramArguments(String ... args) {
        this.addArguments(this.args, args);
    }

    private void addArguments(List<Commandline.Argument> to, String ... args) {
        for (String str : args) {
            Commandline.Argument arg = new Commandline.Argument();
            arg.setValue(str);
            to.add(arg);
        }
    }

    public String[] getProgramArguments() {
        return EquinoxLaunchConfiguration.toStringArray(this.args);
    }

    private static String[] toStringArray(List<Commandline.Argument> args) {
        ArrayList<String> result = new ArrayList<String>();
        for (Commandline.Argument arg : args) {
            for (String str : arg.getParts()) {
                result.add(str);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void addVMArguments(String ... vmargs) {
        this.addArguments(this.vmargs, vmargs);
    }

    public String[] getVMArguments() {
        return EquinoxLaunchConfiguration.toStringArray(this.vmargs);
    }

    public File getLauncherJar() {
        return this.installation.getLauncherJar();
    }
}

