/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;

public class DefaultEquinoxInstallationDescription
implements EquinoxInstallationDescription {
    private static final Map<String, BundleStartLevel> DEFAULT_START_LEVEL = new HashMap<String, BundleStartLevel>();
    protected final DefaultDependencyArtifacts bundles = new DefaultDependencyArtifacts();
    private final Map<String, BundleStartLevel> startLevel = new HashMap<String, BundleStartLevel>(DEFAULT_START_LEVEL);
    private BundleStartLevel defaultBundleStartLevel = null;
    private final List<File> frameworkExtensions = new ArrayList<File>();
    private final Set<String> bundlesToExplode = new HashSet<String>();
    private final Map<String, String> platformProperties = new HashMap<String, String>();
    private final Map<String, String> devEntries = new HashMap<String, String>();

    private static void setDefaultStartLevel(String id, int level) {
        DEFAULT_START_LEVEL.put(id, new BundleStartLevel(id, level, true));
    }

    @Override
    public void addBundleStartLevel(BundleStartLevel level) {
        this.startLevel.put(level.getId(), level);
    }

    @Override
    public Map<String, BundleStartLevel> getBundleStartLevel() {
        return this.startLevel;
    }

    @Override
    public BundleStartLevel getDefaultBundleStartLevel() {
        return this.defaultBundleStartLevel;
    }

    @Override
    public void setDefaultBundleStartLevel(BundleStartLevel defaultBundleStartLevel) {
        this.defaultBundleStartLevel = defaultBundleStartLevel;
    }

    @Override
    public ArtifactDescriptor getBundle(String symbolicName, String highestVersion) {
        return this.bundles.getArtifact("eclipse-plugin", symbolicName, highestVersion);
    }

    @Override
    public List<ArtifactDescriptor> getBundles() {
        return this.bundles.getArtifacts(key -> "eclipse-plugin".equals(key.getType()) || "eclipse-test-plugin".equals(key.getType()));
    }

    @Override
    public ArtifactDescriptor getSystemBundle() {
        return this.bundles.getArtifact("eclipse-plugin", "org.eclipse.osgi", null);
    }

    @Override
    public void addBundle(ArtifactDescriptor artifact) {
        this.bundles.addArtifact(artifact);
    }

    @Override
    public void addBundle(ArtifactKey key, File file) {
        this.addBundle(key, file, false);
    }

    @Override
    public void addBundle(ArtifactKey key, File file, boolean override) {
        if (override) {
            this.bundles.removeAll(key.getType(), key.getId());
        }
        this.bundles.addArtifactFile(key, file, null);
    }

    @Override
    public void addBundlesToExplode(List<String> bundlesToExplode) {
        this.bundlesToExplode.addAll(bundlesToExplode);
    }

    @Override
    public Set<String> getBundlesToExplode() {
        return this.bundlesToExplode;
    }

    @Override
    public void addFrameworkExtensions(List<File> frameworkExtensions) {
        this.frameworkExtensions.addAll(frameworkExtensions);
    }

    @Override
    public List<File> getFrameworkExtensions() {
        return this.frameworkExtensions;
    }

    @Override
    public void addPlatformProperty(String property, String value) {
        this.platformProperties.put(property, value);
    }

    @Override
    public Map<String, String> getPlatformProperties() {
        return this.platformProperties;
    }

    @Override
    public void addDevEntries(String id, String entries) {
        if (entries != null) {
            this.devEntries.merge(id, entries, (s1, s2) -> s1 + "," + s2);
        }
    }

    @Override
    public Map<String, String> getDevEntries() {
        return this.devEntries;
    }

    static {
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.equinox.common", 2);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.core.runtime", 4);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.equinox.simpleconfigurator", 1);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.eclipse.osgi", -1);
        DefaultEquinoxInstallationDescription.setDefaultStartLevel("org.apache.felix.scr", 1);
    }
}

