/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.sisu.osgi.connect.DummyClassRealm;
import org.eclipse.sisu.osgi.connect.PlexusConnectFramework;
import org.eclipse.sisu.osgi.connect.PlexusFrameworkUtilHelper;
import org.eclipse.sisu.osgi.connect.PlexusModuleConnector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.connect.ConnectFrameworkFactory;
import org.osgi.framework.connect.ModuleConnector;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;
import org.osgi.util.tracker.ServiceTracker;

@Component(role=EquinoxServiceFactory.class, hint="connect")
public class PlexusFrameworkConnectServiceFactory
implements Initializable,
Disposable,
EquinoxServiceFactory {
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    @Requirement
    private Logger log;
    private static final Map<ClassRealm, PlexusConnectFramework> frameworkMap = new HashMap<ClassRealm, PlexusConnectFramework>();
    private static final Map<ClassLoader, ClassRealm> loaderMap = new HashMap<ClassLoader, ClassRealm>();
    @Requirement(role=EquinoxLifecycleListener.class)
    private Map<String, EquinoxLifecycleListener> lifecycleListeners;
    private final String name = this.getName(this.getClass().getClassLoader());

    protected String getName(ClassLoader classLoader) {
        if (classLoader instanceof ClassRealm) {
            ClassRealm classRealm = (ClassRealm)classLoader;
            return classRealm.getId();
        }
        return classLoader.toString();
    }

    synchronized PlexusConnectFramework getFramework(ClassRealm realm) throws BundleException {
        PlexusConnectFramework cachedFramework = frameworkMap.get(realm);
        if (cachedFramework != null) {
            return cachedFramework;
        }
        Framework foreignFramework = PlexusFrameworkConnectServiceFactory.getForeignFramework(realm);
        if (foreignFramework != null) {
            PlexusConnectFramework connectFwk = new PlexusConnectFramework(foreignFramework, this.log, this, realm, true);
            frameworkMap.put(realm, connectFwk);
            return connectFwk;
        }
        if (this.log.isDebugEnabled()) {
            this.printRealm(realm, 0, new HashSet<ClassRealm>());
        }
        Collection<ClassRealm> realms = PlexusFrameworkConnectServiceFactory.collectRealms(realm, new LinkedHashSet<ClassRealm>());
        this.log.debug("Create framework for " + this + " with realm " + realm);
        PlexusConnectFramework fwLogger = new PlexusConnectFramework(null, this.log, this, realm, false);
        Map<String, String> p = PlexusFrameworkConnectServiceFactory.readProperties((ClassLoader)realm, fwLogger);
        p.put("org.osgi.framework.system.packages.extra", "javax.security.auth.x500;version=\"1.3.0\", org.slf4j;version=\"1.7.37\"");
        p.put("osgi.framework.useSystemProperties", "false");
        p.put("osgi.parentClassloader", "fwk");
        String storagePath = System.getProperty("java.io.tmpdir") + File.separator + "plexus.osgi." + UUID.randomUUID();
        p.put("org.osgi.framework.storage", storagePath + File.separator + "storage");
        p.put("org.osgi.framework.startlevel.beginning", "6");
        p.put("osgi.instance.area", storagePath + File.separator + "instance");
        ServiceLoader<ConnectFrameworkFactory> loader = ServiceLoader.load(ConnectFrameworkFactory.class, this.getClass().getClassLoader());
        ConnectFrameworkFactory factory = loader.findFirst().orElseThrow(() -> new NoSuchElementException("No ConnectFrameworkFactory found"));
        PlexusModuleConnector connector = new PlexusModuleConnector(factory);
        Framework osgiFramework = factory.newFramework(p, (ModuleConnector)connector);
        PlexusConnectFramework connectFramework = new PlexusConnectFramework(osgiFramework, this.log, this, realm, false);
        PlexusFrameworkUtilHelper.registerHelper(connectFramework);
        osgiFramework.init(new FrameworkListener[]{connectFramework});
        frameworkMap.put(realm, connectFramework);
        connectFramework.start(osgiFramework.getBundleContext());
        for (ClassRealm r : realms) {
            connector.installRealm(r, osgiFramework.getBundleContext(), connectFramework);
        }
        FrameworkWiring wiring = (FrameworkWiring)osgiFramework.adapt(FrameworkWiring.class);
        wiring.resolveBundles(Collections.emptyList());
        osgiFramework.start();
        for (EquinoxLifecycleListener listener : this.lifecycleListeners.values()) {
            connectFramework.debug("Calling " + listener + "...");
            listener.afterFrameworkStarted((EmbeddedEquinox)connectFramework);
        }
        if (this.log.isDebugEnabled()) {
            PlexusFrameworkConnectServiceFactory.printFrameworkState(osgiFramework, connectFramework);
        }
        return connectFramework;
    }

    private void printRealm(ClassRealm realm, int indent, Set<ClassRealm> printed) {
        if (printed.add(realm)) {
            ClassRealm parentRealm = realm.getParentRealm();
            if (parentRealm != null) {
                this.printRealm(parentRealm, indent, printed);
                indent += 2;
            }
            String indentation = StringUtils.repeat((String)" ", (int)indent);
            System.out.println(indentation + "> " + realm.getId() + " (parent = " + realm.getParentRealm() + ")");
            Enumeration resources = realm.loadResourcesFromSelf("META-INF/maven/extension.xml");
            if (resources != null) {
                resources.asIterator().forEachRemaining(url -> System.out.println(indentation + "  " + url));
            }
            realm.display();
            for (ClassRealm imports : realm.getImportRealms()) {
                this.printRealm(imports, indent + 2, printed);
            }
        }
    }

    private static Collection<ClassRealm> collectRealms(ClassRealm realm, Collection<ClassRealm> realms) {
        if (realms.add(realm)) {
            ClassRealm parentRealm = realm.getParentRealm();
            if (parentRealm != null) {
                realms.add(parentRealm);
            }
            for (ClassRealm imported : realm.getImportRealms()) {
                PlexusFrameworkConnectServiceFactory.collectRealms(imported, realms);
            }
        }
        return realms;
    }

    protected ClassRealm getRealm(ClassLoader classloader) {
        if (classloader instanceof ClassRealm) {
            return (ClassRealm)classloader;
        }
        return loaderMap.computeIfAbsent(classloader, cl -> new DummyClassRealm("Not called from a ClassRealm", (ClassLoader)cl));
    }

    private static Map<String, String> readProperties(ClassLoader classloader, Logger logger) {
        Enumeration<URL> resources;
        HashMap<String, String> frameworkProperties = new HashMap<String, String>();
        try {
            resources = classloader.getResources("META-INF/sisu/connect.properties");
        }
        catch (IOException e1) {
            return frameworkProperties;
        }
        resources.asIterator().forEachRemaining(url -> {
            logger.debug("Reading properties from " + url);
            Properties properties = new Properties();
            try (InputStream stream = url.openStream();){
                properties.load(stream);
            }
            catch (IOException e) {
                logger.warn("Can't read properties from url " + url);
            }
            for (String property : properties.stringPropertyNames()) {
                String value = properties.getProperty(property);
                frameworkProperties.merge(property, value, (v1, v2) -> v1 + "," + v2);
            }
        });
        return frameworkProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printFrameworkState(Framework framework, Logger log) {
        Bundle[] bundles = framework.getBundleContext().getBundles();
        log.info("============ Framework Bundles ==================");
        Comparator<Bundle> bySymbolicName = Comparator.comparing(Bundle::getSymbolicName, String.CASE_INSENSITIVE_ORDER);
        Comparator<Bundle> byState = Comparator.comparingInt(Bundle::getState);
        Arrays.stream(bundles).sorted(byState.thenComparing(bySymbolicName)).forEachOrdered(bundle -> {
            String state = PlexusFrameworkConnectServiceFactory.toBundleState(bundle.getState());
            log.info(state + " | " + bundle.getSymbolicName() + " (" + bundle.getVersion() + ") at " + bundle.getLocation());
        });
        st.open();
        try (ServiceTracker st = new ServiceTracker(framework.getBundleContext(), ServiceComponentRuntime.class, null);){
            ServiceComponentRuntime componentRuntime = (ServiceComponentRuntime)st.getService();
            if (componentRuntime != null) {
                log.info("============ Framework Components ==================");
                Collection descriptionDTOs = componentRuntime.getComponentDescriptionDTOs(new Bundle[0]);
                Comparator<ComponentConfigurationDTO> byComponentName = Comparator.comparing(dto -> dto.description.name, String.CASE_INSENSITIVE_ORDER);
                Comparator<ComponentConfigurationDTO> byComponentState = Comparator.comparingInt(dto -> dto.state);
                descriptionDTOs.stream().flatMap(dto -> componentRuntime.getComponentConfigurationDTOs(dto).stream()).sorted(byComponentState.thenComparing(byComponentName)).forEachOrdered(dto -> {
                    if (dto.state == 16) {
                        log.info(PlexusFrameworkConnectServiceFactory.toComponentState(dto.state) + " | " + dto.description.name + " | " + dto.failure);
                    } else {
                        log.info(PlexusFrameworkConnectServiceFactory.toComponentState(dto.state) + " | " + dto.description.name);
                    }
                    for (int i = 0; i < dto.unsatisfiedReferences.length; ++i) {
                        UnsatisfiedReferenceDTO ref = dto.unsatisfiedReferences[i];
                        log.info("\t" + ref.name + " is missing");
                    }
                });
            } else {
                log.info("No service component runtime installed (or started) in this framework!");
            }
        }
        log.info("============ Registered Services ==================");
        Arrays.stream(bundles).map(Bundle::getRegisteredServices).filter(Objects::nonNull).flatMap(Arrays::stream).forEach(reference -> {
            Object service = reference.getProperty("objectClass");
            if (service instanceof Object[]) {
                Object[] objects = (Object[])service;
                service = objects.length == 1 ? objects[0] : Arrays.toString(objects);
            }
            log.info(service + " registered by " + reference.getBundle().getSymbolicName() + " | " + reference.getProperties());
        });
    }

    private static String toComponentState(int state) {
        switch (state) {
            case 8: {
                return "ACTIVE     ";
            }
            case 16: {
                return "FAILED     ";
            }
            case 4: {
                return "SATISFIED  ";
            }
            case 1: 
            case 2: {
                return "UNSATISFIED";
            }
        }
        return String.valueOf(state);
    }

    private static String toBundleState(int state) {
        switch (state) {
            case 32: {
                return "ACTIVE   ";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED ";
            }
            case 8: {
                return "STARTING ";
            }
            case 16: {
                return "STOPPING ";
            }
        }
        return String.valueOf(state);
    }

    public void dispose() {
        frameworkMap.values().removeIf(connect -> {
            if (connect.factory != this) {
                return false;
            }
            if (!connect.foreign) {
                Framework fw = connect.getFramework();
                connect.stop(fw.getBundleContext());
                String storage = fw.getBundleContext().getProperty("org.osgi.framework.storage");
                try {
                    fw.stop();
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
                try {
                    fw.waitForStop(TimeUnit.SECONDS.toMillis(10L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PlexusFrameworkUtilHelper.unregisterHelper(connect);
                if (storage != null) {
                    FileUtils.deleteQuietly((File)new File(storage));
                }
            }
            return true;
        });
    }

    public void initialize() throws InitializationException {
        this.log.debug("Init instance " + this + " [" + this.getClass().getClassLoader() + "]");
    }

    public <T> T getService(Class<T> clazz) {
        return this.locateClass(clazz, null, WALKER.getCallerClass());
    }

    public <T> T getService(Class<T> clazz, String filter) {
        return this.locateClass(clazz, filter, WALKER.getCallerClass());
    }

    private <T> T locateClass(Class<T> clazz, String filter, Class<?> callerClass) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (clazz == null || callerClass == null) {
                T t = null;
                return t;
            }
            ClassRealm realm = this.getRealm(callerClass.getClassLoader());
            T t = this.getFramework(realm).getService(clazz, filter);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public String toString() {
        return this.name;
    }

    public static Framework getForeignFramework(ClassRealm realm) {
        Class<PlexusFrameworkConnectServiceFactory> thisClass = PlexusFrameworkConnectServiceFactory.class;
        Class foreignFactoryClass = realm.loadClassFromSelf(thisClass.getName());
        if (foreignFactoryClass != null && foreignFactoryClass != thisClass) {
            try {
                Method method = foreignFactoryClass.getMethod("getOsgiFramework", ClassRealm.class);
                return (Framework)method.invoke(null, realm);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Framework getOsgiFramework(ClassRealm realm) {
        PlexusConnectFramework cachedFramework = frameworkMap.get(realm);
        if (cachedFramework != null) {
            return cachedFramework.getFramework();
        }
        return null;
    }
}

