/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.connect.FrameworkUtilHelper;

public class PlexusFrameworkUtilHelper
implements FrameworkUtilHelper {
    private static Set<FrameworkUtilHelper> helpers = ConcurrentHashMap.newKeySet();

    public Optional<Bundle> getBundle(Class<?> classFromBundle) {
        ClassLoader loader = classFromBundle.getClassLoader();
        if (loader != null) {
            for (FrameworkUtilHelper helper : helpers) {
                Optional bundle = helper.getBundle(classFromBundle);
                if (!bundle.isPresent()) continue;
                return bundle;
            }
        }
        return Optional.empty();
    }

    public static void registerHelper(FrameworkUtilHelper helper) {
        PlexusFrameworkUtilHelper.modifyHelperRegistry(helper, "registerHelper");
    }

    public static void unregisterHelper(FrameworkUtilHelper helper) {
        PlexusFrameworkUtilHelper.modifyHelperRegistry(helper, "unregisterHelper");
    }

    private static void modifyHelperRegistry(FrameworkUtilHelper helper, String methodName) {
        for (FrameworkUtilHelper spi : ServiceLoader.load(FrameworkUtilHelper.class, FrameworkUtilHelper.class.getClassLoader())) {
            Class spiHelperClass = spi.getClass();
            Class<PlexusFrameworkUtilHelper> thisClass = PlexusFrameworkUtilHelper.class;
            if (!spiHelperClass.getName().equals(thisClass.getName())) continue;
            if (spiHelperClass == thisClass) {
                helpers.add(helper);
                break;
            }
            PlexusFrameworkUtilHelper.invokeForeignMethod(spiHelperClass, methodName, helper);
            break;
        }
    }

    private static void invokeForeignMethod(Class<?> clazz, String methodName, Object parameter) {
        try {
            Method method = clazz.getMethod(methodName, FrameworkUtilHelper.class);
            method.invoke(null, parameter);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

