/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectModule;

class PlexusConnectContent
implements ConnectContent,
ConnectModule {
    private final ClassLoader classLoader;
    private final Optional<Map<String, String>> header;
    private final String location;
    private JarFile jarFile;

    public PlexusConnectContent(JarFile jarFile, Map<String, String> header, ClassLoader classLoader) {
        this.jarFile = jarFile;
        this.location = jarFile == null ? null : jarFile.getName();
        this.classLoader = classLoader;
        this.header = Optional.of(header);
    }

    public Optional<ClassLoader> getClassLoader() {
        return Optional.ofNullable(this.classLoader);
    }

    public Iterable<String> getEntries() throws IOException {
        if (this.jarFile == null) {
            return Collections.emptyList();
        }
        return this.jarFile.stream().map(ZipEntry::getName).toList();
    }

    public Optional<ConnectContent.ConnectEntry> getEntry(String path) {
        if (this.jarFile == null) {
            return Optional.empty();
        }
        ZipEntry entry = this.jarFile.getEntry(path);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(new ZipConnectEntry(this.jarFile, entry));
    }

    public Optional<Map<String, String>> getHeaders() {
        return this.header;
    }

    public void open() throws IOException {
        if (this.jarFile == null && this.location != null) {
            this.jarFile = new JarFile(this.location);
        }
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            try {
                this.jarFile.close();
            }
            finally {
                this.jarFile = null;
            }
        }
    }

    public ConnectContent getContent() throws IOException {
        return this;
    }

    private static final class ZipConnectEntry
    implements ConnectContent.ConnectEntry {
        private ZipEntry entry;
        private JarFile jarFile;

        public ZipConnectEntry(JarFile jarFile, ZipEntry entry) {
            this.jarFile = jarFile;
            this.entry = entry;
        }

        public String getName() {
            return this.entry.getName();
        }

        public long getContentLength() {
            return this.entry.getSize();
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.entry);
        }
    }
}

