/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;

final class DummyClassRealm
extends ClassRealm {
    private static final String JAR_PREFIX = "jar:";
    private static final String JAR_FILE_PREFIX = "jar:file:";
    private ClassLoader classLoader;
    private List<URL> urls;
    private Logger logger;

    DummyClassRealm(String id, ClassLoader classLoader, Logger logger) {
        super(new ClassWorld(), id, classLoader);
        this.classLoader = classLoader;
        this.logger = logger;
    }

    public URL[] getURLs() {
        if (this.urls == null) {
            List filters;
            InputStream stream = this.classLoader.getResourceAsStream("META-INF/sisu/realm.filter");
            if (stream != null) {
                try {
                    filters = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    stream.close();
                }
                catch (IOException e) {
                    filters = null;
                }
            } else {
                filters = null;
            }
            this.urls = new ArrayList<URL>();
            try {
                Enumeration<URL> resources = this.classLoader.getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    String location = resources.nextElement().toExternalForm();
                    if (this.isValidJar(location, filters)) {
                        String name = location.substring(JAR_PREFIX.length()).split("!")[0];
                        this.logger.debug("Adding URL " + name + " to DummyRealm");
                        this.urls.add(new URL(name));
                        continue;
                    }
                    this.logger.debug("Location " + location + " was filtered from DummyRealm");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return (URL[])this.urls.toArray(URL[]::new);
    }

    private boolean isValidJar(String location, List<String> filters) {
        if (location.startsWith(JAR_FILE_PREFIX)) {
            if (filters != null) {
                String normalizedpath = location.replace('\\', '/').toLowerCase();
                for (String filter : filters) {
                    if (filter.isBlank() || filter.startsWith("#") || !normalizedpath.contains(filter)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Class<?> loadClassFromSelf(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public URL loadResourceFromSelf(String name) {
        return this.classLoader.getResource(name);
    }

    public Enumeration<URL> loadResourcesFromSelf(String name) {
        try {
            return this.classLoader.getResources(name);
        }
        catch (IOException e) {
            return null;
        }
    }
}

