/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.target;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManagerFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="target-platform")
public class TargetPlatformMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Component
    private EquinoxServiceFactory osgiServices;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReactorRepositoryManagerFacade repositoryManager = (ReactorRepositoryManagerFacade)this.osgiServices.getService(ReactorRepositoryManagerFacade.class);
        List<ReactorProjectIdentities> upstreamProjects = this.getReferencedTychoProjects();
        repositoryManager.computeFinalTargetPlatform(DefaultReactorProject.adapt((MavenProject)this.project), upstreamProjects);
    }

    private List<ReactorProjectIdentities> getReferencedTychoProjects() throws MojoExecutionException {
        ArrayList<ReactorProjectIdentities> result = new ArrayList<ReactorProjectIdentities>();
        HashSet<GAV> considered = new HashSet<GAV>();
        this.getTransitivelyReferencedTychoProjects(this.project.getProjectReferences().values(), considered, result);
        return result;
    }

    private void getTransitivelyReferencedTychoProjects(Collection<MavenProject> candidateProjects, HashSet<GAV> consideredProjects, List<ReactorProjectIdentities> result) throws MojoExecutionException {
        for (MavenProject reactorProject : candidateProjects) {
            File metadataXml;
            if (!this.enterProject(reactorProject, consideredProjects) || (metadataXml = TargetPlatformMojo.getAttachedArtifact(reactorProject, "p2metadata")) == null) continue;
            File artifactXml = TargetPlatformMojo.getAttachedArtifact(reactorProject, "p2artifacts");
            ReactorProject tychoReactorProject = DefaultReactorProject.adapt((MavenProject)reactorProject);
            TargetPlatformMojo.verifyIndexFileLocations(tychoReactorProject, metadataXml, artifactXml);
            result.add(tychoReactorProject.getIdentities());
            this.getTransitivelyReferencedTychoProjects(reactorProject.getProjectReferences().values(), consideredProjects, result);
        }
    }

    private boolean enterProject(MavenProject project, HashSet<GAV> consideredProjects) {
        GAV projectGav = new GAV(project.getGroupId(), project.getArtifactId(), project.getVersion());
        if (consideredProjects.contains(projectGav)) {
            return false;
        }
        consideredProjects.add(projectGav);
        return true;
    }

    private static File getAttachedArtifact(MavenProject project, String classifier) {
        for (Artifact artifact : project.getAttachedArtifacts()) {
            if (!classifier.equals(artifact.getClassifier())) continue;
            return artifact.getFile();
        }
        return null;
    }

    private static void verifyIndexFileLocations(ReactorProject project, File metadataXml, File artifactXml) throws MojoExecutionException {
        TargetPlatformMojo.verifyArtifactLocationInTargetFolder(project, "p2metadata", "p2content.xml", metadataXml);
        TargetPlatformMojo.verifyArtifactLocationInTargetFolder(project, "p2artifacts", "p2artifacts.xml", artifactXml);
        TargetPlatformMojo.verifyFilePresenceInTargetFolder(project, "local-artifacts.properties");
    }

    private static void verifyArtifactLocationInTargetFolder(ReactorProject project, String artifactClassifier, String expectedPathInTarget, File actualLocation) throws MojoExecutionException {
        File expectedLocation = project.getBuildDirectory().getChild(expectedPathInTarget);
        if (actualLocation == null) {
            throw new MojoExecutionException("Unexpected build result of " + project + ": Artifact with classifier '" + artifactClassifier + "' expected at location \"" + expectedLocation + "\", but is missing");
        }
        if (!expectedLocation.equals(actualLocation.getAbsoluteFile())) {
            throw new MojoExecutionException("Unexpected build result of " + project + ": Artifact with classifier '" + artifactClassifier + "' expected at location \"" + expectedLocation + "\", but is at \"" + actualLocation.getAbsolutePath() + "\"");
        }
    }

    private static void verifyFilePresenceInTargetFolder(ReactorProject project, String expectedPathInTarget) throws MojoExecutionException {
        File expectedLocation = project.getBuildDirectory().getChild(expectedPathInTarget);
        if (!expectedLocation.isFile()) {
            throw new MojoExecutionException("Unexpected build result of " + project + ": File \"" + expectedLocation + "\" is missing");
        }
    }
}

