/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.target;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformConfigurationReader;
import org.eclipse.tycho.p2maven.InstallableUnitProvider;

@Component(role=InstallableUnitProvider.class, hint="target")
public class TargetPlatformConfigurationInstallableUnitProvider
implements InstallableUnitProvider {
    @Requirement
    private DefaultTargetPlatformConfigurationReader configurationReader;
    @Requirement
    private Logger logger;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        if (this.projectTypes.get(project.getPackaging()) == null) {
            return Collections.emptyList();
        }
        TargetPlatformConfiguration configuration = this.configurationReader.getTargetPlatformConfiguration(session, project);
        List<IRequirement> extraRequirements = configuration.getExtraRequirements().stream().map(key -> TargetPlatformConfigurationInstallableUnitProvider.createRequirementFor(key.getType(), key.getId(), new VersionRange(key.getVersion()))).filter(Objects::nonNull).collect(Collectors.toList());
        if (extraRequirements.isEmpty()) {
            return Collections.emptyList();
        }
        return List.of(TargetPlatformConfigurationInstallableUnitProvider.createUnitRequiring(extraRequirements));
    }

    private static IRequirement createRequirementFor(String type, String id, VersionRange versionRange) {
        switch (type) {
            case "eclipse-plugin": {
                return MetadataFactory.createRequirement((String)"osgi.bundle", (String)id, (VersionRange)versionRange, null, (boolean)false, (boolean)true);
            }
            case "eclipse-feature": {
                return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)(id + ".feature.group"), (VersionRange)versionRange, null, (boolean)false, (boolean)true);
            }
            case "p2-installable-unit": {
                return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)versionRange, null, (boolean)false, (boolean)true);
            }
            case "eclipse-product": {
                return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)versionRange, null, (boolean)false, (boolean)true);
            }
        }
        return null;
    }

    private static IInstallableUnit createUnitRequiring(Collection<IRequirement> requirements) {
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        result.setId("target-platform-extra-requirements-" + UUID.randomUUID());
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)String.valueOf(System.currentTimeMillis())));
        result.addRequirements(requirements);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result);
    }
}

