/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.target;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetPlatformService;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;

@Mojo(name="target-platform", threadSafe=true)
public class TargetPlatformMojo
extends AbstractMojo {
    private static final String TARGET_PLATFORM_MOJO_EXECUTED = "TargetPlatformMojo.executed";
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Component
    private TargetPlatformService platformService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        Object executed = reactorProject.getContextValue(TARGET_PLATFORM_MOJO_EXECUTED);
        if (executed != null) {
            this.platformService.clearTargetPlatform(reactorProject);
        } else {
            reactorProject.setContextValue(TARGET_PLATFORM_MOJO_EXECUTED, (Object)Boolean.TRUE);
        }
        this.platformService.getTargetPlatform(reactorProject);
    }
}

