/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.apitools;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TychoConstants;
import org.eclipse.tycho.apitools.ApiAnalysis;
import org.eclipse.tycho.apitools.ApiAnalysisResult;
import org.eclipse.tycho.apitools.ApiApplicationResolver;
import org.eclipse.tycho.core.EcJLogFileEnhancer;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.exceptions.VersionBumpRequiredException;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.model.project.EclipseProject;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.osgi.framework.EclipseFramework;
import org.eclipse.tycho.osgi.framework.EclipseWorkspace;
import org.eclipse.tycho.osgi.framework.EclipseWorkspaceManager;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

@org.apache.maven.plugins.annotations.Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ApiAnalysisMojo
extends AbstractMojo {
    static final String BUNDLE_APP = "org.eclipse.equinox.app";
    static final String BUNDLE_SCR = "org.apache.felix.scr";
    static final String BUNDLE_CORE = "org.eclipse.core.runtime";
    @Parameter(property="plugin.artifacts")
    protected List<Artifact> pluginArtifacts;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="eclipse-plugin")
    private Set<String> supportedPackagingTypes;
    @Parameter(defaultValue="false", property="tycho.apitools.verify.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="tycho.apitools.debug")
    private boolean debug;
    @Parameter(defaultValue="true", property="tycho.apitools.verify.skipIfReplaced")
    private boolean skipIfReplaced;
    @Parameter(property="baselines", name="baselines")
    private List<Repository> baselines;
    @Parameter
    private Repository apiToolsRepository;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private Map<String, String> properties;
    @Parameter(defaultValue="${project.basedir}/.settings/.api_filters")
    private File apiFilter;
    @Parameter(defaultValue="${project.basedir}/.settings/org.eclipse.pde.api.tools.prefs")
    private File apiPreferences;
    @Parameter(defaultValue="${project.build.directory}/compile-logs")
    private File logDirectory;
    @Parameter(defaultValue="true", property="tycho.apitools.printProblems")
    private boolean printProblems;
    @Parameter(defaultValue="true", property="tycho.apitools.printSummary")
    private boolean printSummary;
    @Parameter(defaultValue="false")
    private boolean failOnResolutionError;
    @Parameter(defaultValue="true", property="tycho.apitools.failOnError")
    private boolean failOnError;
    @Parameter(defaultValue="false", property="tycho.apitools.failOnWarning")
    private boolean failOnWarning;
    @Parameter(defaultValue="false", property="tycho.apitools.failOnVersion")
    private boolean failOnVersion;
    @Parameter(defaultValue="false")
    private boolean parallel;
    @Parameter(defaultValue="false", property="tycho.apitools.enhanceLogs")
    private boolean enhanceLogs;
    @Parameter(defaultValue="true", property="tycho.apitools.runAsJob")
    private boolean runAsJob;
    @Component
    private EclipseWorkspaceManager workspaceManager;
    @Component
    private TychoProjectManager projectManager;
    @Component
    private ApiApplicationResolver applicationResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        List warnings;
        List<IApiProblem> errors;
        Log log;
        block27: {
            ApiAnalysisResult analysisResult;
            EclipseFramework eclipseFramework;
            Collection dependencyBundles;
            if (this.skip) {
                return;
            }
            Optional eclipseProjectValue = this.projectManager.getEclipseProject(this.project);
            if (eclipseProjectValue.isEmpty()) return;
            if (!((EclipseProject)eclipseProjectValue.get()).hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
                return;
            }
            EclipseProject eclipseProject = (EclipseProject)eclipseProjectValue.get();
            if (!this.supportedPackagingTypes.contains(this.project.getPackaging())) return;
            log = this.getLog();
            if (this.skipIfReplaced && this.wasReplaced()) {
                log.info((CharSequence)"Skipped because main artifact was replaced with baseline!");
                return;
            }
            long start = System.currentTimeMillis();
            Collection<Path> baselineBundles = this.getBaselineBundles();
            if (baselineBundles.isEmpty()) {
                log.info((CharSequence)"Skipped because no bundles in the baseline!");
                return;
            }
            try {
                dependencyBundles = this.projectManager.getProjectDependencies(this.project);
            }
            catch (Exception e) {
                throw new MojoFailureException("Can't fetch dependencies!", (Throwable)e);
            }
            MavenRepositoryLocation repository = this.getRepository();
            EclipseWorkspace workspace = this.workspaceManager.getWorkspace(repository.getURL(), (Mojo)this);
            EclipseApplication apiApplication = this.applicationResolver.getApiApplication(repository);
            try {
                eclipseFramework = apiApplication.startFramework(workspace, List.of());
            }
            catch (BundleException e) {
                throw new MojoFailureException("Start Framework failed!", (Throwable)e);
            }
            if (this.parallel) {
                analysisResult = this.performAnalysis(baselineBundles, dependencyBundles, eclipseFramework, eclipseProject);
            } else {
                Class<ApiAnalysisMojo> clazz = ApiAnalysisMojo.class;
                // MONITORENTER : org.eclipse.tycho.apitools.ApiAnalysisMojo.class
                analysisResult = this.performAnalysis(baselineBundles, dependencyBundles, eclipseFramework, eclipseProject);
                // MONITOREXIT : clazz
            }
            log.info((CharSequence)("API Analysis finished in " + this.time(start) + "."));
            analysisResult.resolveErrors().forEach(resolveError -> log.warn((CharSequence)(resolveError + " analysis might be inaccurate!")));
            Map<Integer, List<IApiProblem>> problems = analysisResult.problems().collect(Collectors.groupingBy(IApiProblem::getSeverity));
            errors = problems.getOrDefault(2, List.of());
            warnings = problems.getOrDefault(1, List.of());
            if (this.printProblems) {
                for (IApiProblem problem2 : errors) {
                    this.printProblem(problem2, "API ERROR", arg_0 -> ((Log)log).error(arg_0));
                }
                for (IApiProblem problem2 : warnings) {
                    this.printProblem(problem2, "API WARNING", arg_0 -> ((Log)log).warn(arg_0));
                }
            }
            if (this.enhanceLogs && this.logDirectory != null && this.logDirectory.isDirectory()) {
                try {
                    Map<String, List<IApiProblem>> problemsMap = analysisResult.problems().collect(Collectors.groupingBy(problem -> (String)((Object)Objects.requireNonNullElse(problem.getResourcePath(), "no-path-" + System.identityHashCode(problem)))));
                    if (problemsMap.isEmpty()) break block27;
                    try (EcJLogFileEnhancer enhancer = EcJLogFileEnhancer.create((File)this.logDirectory);){
                        this.enhanceLog(enhancer, problemsMap);
                    }
                }
                catch (IOException e) {
                    log.warn((CharSequence)("Can't enhance logs in directory " + this.logDirectory));
                }
            }
        }
        if (this.printSummary) {
            log.info((CharSequence)(errors.size() + " API ERRORS"));
            log.info((CharSequence)(warnings.size() + " API warnings"));
        }
        if (errors.size() > 0 && this.failOnError) {
            throw this.getApiError(errors);
        }
        if (errors.size() > 0 && this.failOnVersion && errors.stream().anyMatch(problem -> problem.getCategory() == 0x30000000)) {
            throw this.getApiError(errors);
        }
        if (warnings.size() <= 0) return;
        if (!this.failOnWarning) return;
        String msg = warnings.stream().map(problem -> {
            if (problem.getResourcePath() == null) {
                return problem.getMessage();
            }
            return problem.getResourcePath() + ":" + problem.getLineNumber() + " " + problem.getMessage();
        }).collect(Collectors.joining(System.lineSeparator()));
        throw new MojoFailureException("There are API warnings:" + System.lineSeparator() + msg);
    }

    private MojoFailureException getApiError(List<IApiProblem> errors) {
        String problems = errors.stream().map(problem -> {
            if (problem.getResourcePath() == null) {
                return problem.getMessage();
            }
            return problem.getResourcePath() + ":" + problem.getLineNumber() + " " + problem.getMessage();
        }).collect(Collectors.joining(System.lineSeparator()));
        String message = "There are API errors:" + System.lineSeparator() + problems;
        for (IApiProblem problem2 : errors) {
            if (problem2.getCategory() != 0x30000000) continue;
            switch (problem2.getKind()) {
                case 1: 
                case 5: 
                case 10: {
                    return new VersionBumpRequiredException(message, this.project, this.getSuggestedVersion(current -> new Version(current.getMajor() + 1, 0, 0)));
                }
                case 2: 
                case 6: 
                case 7: {
                    return new VersionBumpRequiredException(message, this.project, this.getSuggestedVersion(current -> new Version(current.getMajor(), current.getMinor() + 1, 0)));
                }
            }
        }
        return new MojoFailureException(message);
    }

    private Version getSuggestedVersion(Function<Version, Version> update) {
        try {
            Optional key = this.projectManager.getArtifactKey(this.project);
            if (key.isPresent()) {
                String version = ((ArtifactKey)key.get()).getVersion();
                Version current = Version.parseVersion((String)version);
                return update.apply(current);
            }
        }
        catch (RuntimeException e) {
            this.getLog().warn((CharSequence)"Can't determine suggested version!");
        }
        return null;
    }

    private void enhanceLog(EcJLogFileEnhancer enhancer, Map<String, List<IApiProblem>> problemsMap) {
        Log log = this.getLog();
        int notMapped = 0;
        for (Map.Entry<String, List<IApiProblem>> problemEntry : problemsMap.entrySet()) {
            String path = problemEntry.getKey();
            List<IApiProblem> problemsList = problemEntry.getValue();
            List<EcJLogFileEnhancer.Source> list = enhancer.sources().filter(source -> {
                String pathAttribute = source.getPath();
                return pathAttribute != null && !pathAttribute.isEmpty() && pathAttribute.endsWith(path);
            }).toList();
            if (list.isEmpty()) {
                for (IApiProblem notfound : problemsList) {
                    ++notMapped;
                    if (this.printProblems) continue;
                    if (2 == notfound.getSeverity()) {
                        this.printProblem(notfound, "API ERROR", arg_0 -> ((Log)log).error(arg_0));
                        continue;
                    }
                    if (1 != notfound.getSeverity()) continue;
                    this.printProblem(notfound, "API WARNING", arg_0 -> ((Log)log).warn(arg_0));
                }
                continue;
            }
            Map<Integer, List<IApiProblem>> problemsBySeverity = problemsList.stream().collect(Collectors.groupingBy(IApiProblem::getSeverity));
            List errors = problemsBySeverity.getOrDefault(2, List.of());
            List warnings = problemsBySeverity.getOrDefault(1, List.of());
            for (EcJLogFileEnhancer.Source sourceEntry : list) {
                for (IApiProblem problem : warnings) {
                    sourceEntry.addProblem("WARNING", problem.getLineNumber(), problem.getCharStart(), problem.getCharEnd(), problem.getCategory(), problem.getId(), problem.getMessage());
                }
                for (IApiProblem problem : errors) {
                    sourceEntry.addProblem("ERROR", problem.getLineNumber(), problem.getCharStart(), problem.getCharEnd(), problem.getCategory(), problem.getId(), problem.getMessage());
                }
            }
        }
        if (notMapped > 0) {
            log.warn((CharSequence)(notMapped + " API problems can't be mapped to the compiler log!"));
        }
    }

    private ApiAnalysisResult performAnalysis(Collection<Path> baselineBundles, Collection<Path> dependencyBundles, EclipseFramework eclipseFramework, EclipseProject eclipseProject) throws MojoExecutionException {
        try {
            ApiAnalysis analysis = new ApiAnalysis(baselineBundles, dependencyBundles, this.project.getName(), eclipseProject.getFile(ApiAnalysisMojo.fileToPath(this.apiFilter)), eclipseProject.getFile(ApiAnalysisMojo.fileToPath(this.apiPreferences)), ApiAnalysisMojo.fileToPath(this.project.getBasedir()), this.debug, ApiAnalysisMojo.fileToPath(this.project.getArtifact().getFile()), ApiAnalysisMojo.stringToPath(this.project.getBuild().getOutputDirectory()), this.runAsJob);
            ApiAnalysisResult apiAnalysisResult = (ApiAnalysisResult)eclipseFramework.execute((Callable)analysis);
            return apiAnalysisResult;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Execute ApiApplication failed", e);
        }
        finally {
            eclipseFramework.close();
        }
    }

    private void printProblem(IApiProblem problem, String type, Consumer<CharSequence> consumer) {
        Path path = this.getFullPath(problem);
        String file = path.getFileName().toString();
        int lineNumber = problem.getLineNumber();
        String message = problem.getMessage().trim();
        consumer.accept(String.format("[%s] File %s at line %d: %s (location: %s)", type, file, lineNumber, message, path));
    }

    private Path getFullPath(IApiProblem problem) {
        String path = problem.getResourcePath();
        if (path == null) {
            return Path.of("unknown", new String[0]);
        }
        return this.project.getBasedir().toPath().resolve(path);
    }

    private boolean wasReplaced() {
        Object object = DefaultReactorProject.adapt((MavenProject)this.project).getContextValue(TychoConstants.KEY_BASELINE_REPLACE_ARTIFACT_MAIN);
        if (object instanceof Boolean) {
            Boolean replaced = (Boolean)object;
            return replaced;
        }
        return false;
    }

    private MavenRepositoryLocation getRepository() {
        if (this.apiToolsRepository == null || this.apiToolsRepository.getUrl() == null) {
            return new MavenRepositoryLocation(null, URI.create("https://download.eclipse.org/releases/2024-09/"));
        }
        return new MavenRepositoryLocation(this.apiToolsRepository.getId(), URI.create(this.apiToolsRepository.getUrl()));
    }

    private Collection<Path> getBaselineBundles() throws MojoFailureException {
        long start = System.currentTimeMillis();
        try {
            Collection<TargetEnvironment> targetEnvironments = this.getBaselineEnvironments();
            Optional artifactKey = this.projectManager.getArtifactKey(this.project);
            this.getLog().info((CharSequence)("Resolve API baseline for " + this.project.getId() + " with " + targetEnvironments.stream().map(String::valueOf).collect(Collectors.joining(", "))));
            Collection<Path> baselineBundles = this.applicationResolver.getApiBaselineBundles(this.baselines.stream().filter(repo -> repo.getUrl() != null).map(repo -> new MavenRepositoryLocation(repo.getId(), URI.create(repo.getUrl()))).toList(), (ArtifactKey)artifactKey.get(), targetEnvironments);
            this.getLog().debug((CharSequence)("API baseline contains " + baselineBundles.size() + " bundles (resolve takes " + this.time(start) + ")."));
            return baselineBundles;
        }
        catch (IllegalArtifactReferenceException e) {
            throw new MojoFailureException("Project specify an invalid artifact key", (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            if (this.failOnResolutionError) {
                throw new MojoFailureException("Can't resolve API baseline!", (Throwable)e);
            }
            this.getLog().warn((CharSequence)("Can't resolve API baseline: " + Objects.requireNonNullElse(e.getMessage(), e.toString())));
            return List.of();
        }
    }

    private Collection<TargetEnvironment> getBaselineEnvironments() {
        Collection targetEnvironments = this.projectManager.getTargetEnvironments(this.project);
        TargetEnvironment runningEnvironment = TargetEnvironment.getRunningEnvironment();
        for (TargetEnvironment targetEnvironment : targetEnvironments) {
            if (!targetEnvironment.equals((Object)runningEnvironment)) continue;
            return List.of(targetEnvironment);
        }
        return targetEnvironments;
    }

    private String time(long start) {
        long ms = System.currentTimeMillis() - start;
        if (ms < 1000L) {
            return ms + " ms";
        }
        long sec = ms / 1000L;
        return sec + " s";
    }

    private static Path stringToPath(String file) {
        if (file == null) {
            return null;
        }
        return Path.of(file, new String[0]);
    }

    private static Path fileToPath(File file) {
        if (file != null) {
            return file.toPath();
        }
        return null;
    }
}

