/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.apitools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.api.tools.internal.BundleListTargetLocation;
import org.eclipse.pde.api.tools.internal.FilterStore;
import org.eclipse.pde.api.tools.internal.builder.BaseApiAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.tycho.apitools.ApiAnalysisResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ApiAnalysis
implements Serializable,
Callable<ApiAnalysisResult> {
    private Collection<String> baselineBundles;
    private Collection<String> targetBundles;
    private String baselineName;
    private String apiFilterFile;
    private String projectDir;
    private boolean debug;
    private String apiPreferences;
    private String binaryArtifact;
    private String outputDir;

    ApiAnalysis(Collection<java.nio.file.Path> baselineBundles, Collection<java.nio.file.Path> dependencyBundles, String baselineName, java.nio.file.Path apiFilterFile, java.nio.file.Path apiPreferences, java.nio.file.Path projectDir, boolean debug, java.nio.file.Path binaryArtifact, java.nio.file.Path outputDir) {
        this.targetBundles = dependencyBundles.stream().map(ApiAnalysis::pathAsString).toList();
        this.baselineBundles = baselineBundles.stream().map(ApiAnalysis::pathAsString).toList();
        this.baselineName = baselineName;
        this.apiFilterFile = ApiAnalysis.pathAsString(apiFilterFile);
        this.apiPreferences = ApiAnalysis.pathAsString(apiPreferences);
        this.projectDir = ApiAnalysis.pathAsString(projectDir);
        this.binaryArtifact = ApiAnalysis.pathAsString(binaryArtifact);
        this.outputDir = projectDir.relativize(outputDir).toString();
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiAnalysisResult call() throws Exception {
        Platform.addLogListener((status, plugin) -> this.debug(status.toString()));
        IJobManager jobManager = Job.getJobManager();
        jobManager.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
                ApiAnalysis.this.debug("Job " + event.getJob() + " sleeping...");
            }

            public void scheduled(IJobChangeEvent event) {
                ApiAnalysis.this.debug("Job " + event.getJob() + " scheduled...");
            }

            public void running(IJobChangeEvent event) {
                ApiAnalysis.this.debug("Job " + event.getJob() + " running...");
            }

            public void done(IJobChangeEvent event) {
                ApiAnalysis.this.debug("Job " + event.getJob() + " done...");
            }

            public void awake(IJobChangeEvent event) {
                ApiAnalysis.this.debug("Job " + event.getJob() + " awake...");
            }

            public void aboutToRun(IJobChangeEvent event) {
                ApiAnalysis.this.debug("Job " + event.getJob() + " aboutToRun...");
            }
        });
        this.printVersion();
        this.disableAutoBuild();
        this.disableJVMDiscovery();
        this.setTargetPlatform();
        this.deleteAllProjects();
        IPath projectPath = IPath.fromOSString((String)this.projectDir);
        IProject project = this.getProject(projectPath);
        BundleComponent projectComponent = this.getApiComponent(project, projectPath);
        IApiBaseline baseline = this.createBaseline(this.baselineBundles, this.baselineName + " - baseline");
        ResolverError[] resolverErrors = projectComponent.getErrors();
        ApiAnalysisResult result = new ApiAnalysisResult(this.getVersion());
        if (resolverErrors != null && resolverErrors.length > 0) {
            for (ResolverError error : resolverErrors) {
                result.addResolverError(error);
            }
        }
        IApiFilterStore filterStore = this.getApiFilterStore(projectComponent);
        Properties preferences = this.getPreferences();
        BaseApiAnalyzer analyzer = new BaseApiAnalyzer();
        try {
            IApiProblem[] problems;
            analyzer.setContinueOnResolverError(true);
            analyzer.analyzeComponent(null, filterStore, preferences, baseline, (IApiComponent)projectComponent, (IBuildContext)new BuildContext(), (IProgressMonitor)new NullProgressMonitor());
            for (IApiProblem problem : problems = analyzer.getProblems()) {
                result.addProblem(problem, project);
                this.debug(String.valueOf(problem));
            }
        }
        finally {
            analyzer.dispose();
            ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        JRTUtil.reset();
        return result;
    }

    private String getVersion() {
        Bundle apiToolsBundle = FrameworkUtil.getBundle(ApiModelFactory.class);
        if (apiToolsBundle != null) {
            return apiToolsBundle.getVersion().toString();
        }
        return "n/a";
    }

    private void disableJVMDiscovery() {
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode(LaunchingPlugin.getDefault().getBundle().getSymbolicName());
        instanceNode.putBoolean("detectVMsAtStartup", false);
    }

    private BundleComponent getApiComponent(IProject project, IPath projectPath) throws CoreException, IOException {
        IApiComponent[] components;
        IApiBaseline workspaceBaseline = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline();
        IApiComponent component = workspaceBaseline.getApiComponent(project);
        if (component instanceof ProjectComponent) {
            ProjectComponent projectComponent = (ProjectComponent)component;
            this.debug("Project component was found");
            return projectComponent;
        }
        for (IApiComponent c : components = workspaceBaseline.getApiComponents()) {
            String location = c.getLocation();
            if (location == null || !IPath.fromOSString((String)location).equals((Object)projectPath) || !(c instanceof BundleComponent)) continue;
            BundleComponent bundle = (BundleComponent)c;
            this.debug("Fallback to binary bundle component");
            return bundle;
        }
        if (this.binaryArtifact != null) {
            this.debug("Fallback to binary artifact");
            IApiComponent binaryComponent = ApiModelFactory.newApiComponent((IApiBaseline)workspaceBaseline, (String)this.binaryArtifact);
            if (binaryComponent instanceof BundleComponent) {
                BundleComponent bundle = (BundleComponent)binaryComponent;
                workspaceBaseline.addApiComponents(new IApiComponent[]{bundle});
                return bundle;
            }
        }
        throw new RuntimeException("Can't import project");
    }

    private IProject getProject(IPath projectPath) throws CoreException, IOException {
        IPath projectDescriptionFile = projectPath.append(".project");
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(projectDescriptionFile);
        projectDescription.setLocation(projectPath);
        projectDescription.setBuildSpec(new ICommand[0]);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath.lastSegment());
        project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        this.createOutputFolder(project, projectPath);
        return project;
    }

    private void createOutputFolder(IProject project, IPath projectPath) throws IOException, CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IClasspathEntry[] classpath;
            Map<String, String> outputJars = this.computeOutputJars(project, javaProject);
            IFolder outputFolder = project.getFolder(this.outputDir);
            IPath mainOutputLocation = javaProject.getOutputLocation();
            IPath mainRealPath = this.getRealPath(mainOutputLocation, outputJars, outputFolder);
            this.makeOutputFolder(mainOutputLocation, mainRealPath);
            for (IClasspathEntry entry : classpath = javaProject.getRawClasspath()) {
                IPath entryOutputLocation = entry.getOutputLocation();
                if (entryOutputLocation == null) continue;
                IPath realEntryPath = this.getRealPath(entryOutputLocation, outputJars, outputFolder);
                this.makeOutputFolder(entryOutputLocation, realEntryPath);
            }
        }
    }

    private Map<String, String> computeOutputJars(IProject project, IJavaProject javaProject) throws CoreException {
        IBuildModel model;
        HashMap<String, String> outputJars = new HashMap<String, String>();
        IPluginModelBase base = PluginRegistry.findModel((IProject)project);
        if (base != null && (model = PluginRegistry.createBuildModel((IPluginModelBase)base)) != null) {
            IBuildEntry[] entries;
            IBuild ibuild = model.getBuild();
            for (IBuildEntry entry : entries = ibuild.getBuildEntries()) {
                String key;
                String name = entry.getName();
                if (name.startsWith("output.")) {
                    key = name.substring("output.".length());
                    for (String token : entry.getTokens()) {
                        outputJars.put(this.normalizeOutputPath(token), key);
                    }
                    continue;
                }
                if (!name.startsWith("source.")) continue;
                key = name.substring("source.".length());
                IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
                for (String token : entry.getTokens()) {
                    IPath srcPath = project.getFolder(token).getFullPath();
                    for (IClasspathEntry classpathEntry : rawClasspath) {
                        IPath path;
                        if (classpathEntry.getEntryKind() != 3 || !srcPath.equals((Object)(path = classpathEntry.getPath()))) continue;
                        IPath outputLocation = classpathEntry.getOutputLocation();
                        if (outputLocation == null) {
                            outputLocation = javaProject.getOutputLocation();
                        }
                        IFolder folder = this.getProjectFolder(outputLocation);
                        String tokenOutput = folder.getProjectRelativePath().toString();
                        outputJars.putIfAbsent(this.normalizeOutputPath(tokenOutput), key);
                    }
                }
            }
        }
        return outputJars;
    }

    private String normalizeOutputPath(String path) {
        if (path != null && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private IPath getRealPath(IPath eclipseOutputLocation, Map<String, String> outputJars, IFolder mavenOutputFolder) {
        if (eclipseOutputLocation == null) {
            return null;
        }
        IFolder projectFolder = this.getProjectFolder(eclipseOutputLocation);
        for (Map.Entry<String, String> entry : outputJars.entrySet()) {
            IFolder jarFolder = projectFolder.getProject().getFolder(entry.getKey());
            if (!jarFolder.equals(projectFolder)) continue;
            String jarOutputPath = entry.getValue();
            if (".".equals(jarOutputPath) || outputJars.size() == 1) {
                return mavenOutputFolder.getFullPath();
            }
            return mavenOutputFolder.getParent().getFolder((IPath)new Path(jarOutputPath + "-classes")).getFullPath();
        }
        return eclipseOutputLocation;
    }

    private IFolder makeOutputFolder(IPath eclipseOutputLocation, IPath mavenOutputLocation) throws CoreException, IOException {
        if (eclipseOutputLocation != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFolder folder = workspace.getRoot().getFolder(eclipseOutputLocation);
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (mavenOutputLocation != null && !eclipseOutputLocation.equals((Object)mavenOutputLocation)) {
                this.copy(this.getFile(mavenOutputLocation), this.getFile(eclipseOutputLocation));
            }
            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            return folder;
        }
        return null;
    }

    private File getFile(IPath path) {
        if (path == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = workspace.getRoot().getFolder(path).getLocation();
        if (location == null) {
            return null;
        }
        return location.toFile();
    }

    private void copy(final File from, File to) throws IOException {
        if (from == null || to == null || !from.isDirectory() || !to.isDirectory()) {
            return;
        }
        final java.nio.file.Path targetPath = to.toPath();
        Files.walkFileTree(from.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(targetPath.resolve(from.toPath().relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, targetPath.resolve(from.toPath().relativize(file)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private IFolder getProjectFolder(IPath path) {
        if (path != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            return workspace.getRoot().getFolder(path);
        }
        return null;
    }

    private void deleteAllProjects() throws CoreException {
        for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            project.delete(9, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void disableAutoBuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(false);
        workspace.setDescription(desc);
        PDECore.getDefault().getPreferencesManager().setValue("Preferences.MainPage.disableAPIAnalysisBuilder", false);
        PDECore.getDefault().getPreferencesManager().setValue("Preferences.MainPage.runAPIAnalysisAsJob", false);
    }

    private Properties getPreferences() throws IOException {
        java.nio.file.Path path;
        Properties properties = new Properties();
        if (this.apiPreferences != null && Files.isRegularFile(path = java.nio.file.Path.of(this.apiPreferences, new String[0]), new LinkOption[0])) {
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(stream);
            }
        }
        return properties;
    }

    private void printVersion() {
        this.debug("API Tools version: " + this.getVersion());
    }

    private IApiBaseline createBaseline(Collection<String> bundles, String name) throws CoreException {
        this.debug("==== " + name + " ====");
        IApiBaseline baseline = ApiModelFactory.newApiBaseline((String)name);
        ArrayList<IApiComponent> baselineComponents = new ArrayList<IApiComponent>();
        for (String baselineBundle : bundles) {
            IApiComponent component = ApiModelFactory.newApiComponent((IApiBaseline)baseline, (String)baselineBundle);
            if (component == null) continue;
            this.debug(component.getSymbolicName() + " " + component.getVersion() + " -- " + new File(Objects.requireNonNullElse(component.getLocation(), "Unknown")).getName());
            baselineComponents.add(component);
        }
        baseline.addApiComponents((IApiComponent[])baselineComponents.toArray(IApiComponent[]::new));
        for (IApiComponent component : baseline.getApiComponents()) {
            if (!(component instanceof SystemLibraryApiComponent)) continue;
            SystemLibraryApiComponent systemLibrary = (SystemLibraryApiComponent)component;
            this.debug("System Component:");
            this.debug("\tVersion: " + systemLibrary.getVersion());
            this.debug("\tLocation: " + systemLibrary.getLocation());
            for (String ee : systemLibrary.getExecutionEnvironments()) {
                this.debug("\tExecution Environment: " + ee);
            }
        }
        return baseline;
    }

    private IApiFilterStore getApiFilterStore(BundleComponent bundle) {
        return new FilterStore(bundle){

            protected synchronized void initializeApiFilters() {
                if (this.fFilterMap == null) {
                    java.nio.file.Path path;
                    this.fFilterMap = new HashMap(5);
                    if (ApiAnalysis.this.apiFilterFile != null && Files.isRegularFile(path = java.nio.file.Path.of(ApiAnalysis.this.apiFilterFile, new String[0]), new LinkOption[0])) {
                        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                            this.readFilterFile(stream);
                        }
                        catch (IOException e) {
                            ApiAnalysis.this.debug(e.toString());
                        }
                    }
                }
            }
        };
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private void setTargetPlatform() throws IOException, CoreException, InterruptedException {
        ITargetPlatformService service = TargetPlatformService.getDefault();
        ITargetDefinition target = service.newTarget();
        target.setName("buildpath");
        TargetBundle[] bundles = (TargetBundle[])this.targetBundles.stream().map(absoluteFile -> {
            try {
                return new TargetBundle(new File((String)absoluteFile));
            }
            catch (CoreException e) {
                this.debug(e.toString());
                return null;
            }
        }).filter(Objects::nonNull).toArray(TargetBundle[]::new);
        target.setTargetLocations(new ITargetLocation[]{new BundleListTargetLocation(bundles)});
        service.saveTargetDefinition(target);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
        job.schedule();
        job.join();
    }

    private static String pathAsString(java.nio.file.Path path) {
        if (path != null) {
            return path.toAbsolutePath().toString();
        }
        return null;
    }
}

