/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.apitools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.tycho.apitools.ApiProblemDTO;
import org.eclipse.tycho.apitools.ResolverErrorDTO;

public class ApiAnalysisResult
implements Serializable {
    private List<IApiProblem> problems = new ArrayList<IApiProblem>();
    private List<ResolverError> resolveError = new ArrayList<ResolverError>();
    private String version;

    public ApiAnalysisResult(String version) {
        this.version = version;
    }

    public Stream<IApiProblem> problems() {
        return this.problems.stream();
    }

    public Stream<ResolverError> resolveErrors() {
        return this.resolveError.stream();
    }

    public void addProblem(IApiProblem problem, IProject project) {
        this.problems.add(new ApiProblemDTO(problem, project));
    }

    public void addResolverError(ResolverError error) {
        this.resolveError.add(new ResolverErrorDTO(error));
    }

    public String getApiToolsVersion() {
        return this.version;
    }
}

