/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.apitools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.pde.api.tools.internal.APIFileGenerator;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.model.project.EclipseProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class ApiFileGenerationMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File targetFolder;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File binaryLocations;
    @Parameter(defaultValue="${project.basedir}")
    protected File projectLocation;
    @Parameter(defaultValue="${project.artifactId}_${project.version}")
    protected String projectName;
    @Parameter(defaultValue="false")
    private boolean allowNonApiProject;
    @Parameter
    protected String encoding;
    @Parameter
    protected boolean debug;
    @Parameter
    protected List<File> extraManifests = List.of();
    @Parameter
    protected List<File> extraSourceLocations = List.of();
    @Parameter(defaultValue="false", property="tycho.apitools.generate.skip")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean addSourceFolders;
    @Component
    private TychoProjectManager projectManager;
    @Component
    private BuildPropertiesParser buildPropertiesParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Optional eclipseProject = this.projectManager.getEclipseProject(this.project);
        if (eclipseProject.isEmpty() || !((EclipseProject)eclipseProject.get()).hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
            return;
        }
        if (!new File(this.project.getBasedir(), "META-INF/MANIFEST.MF").isFile() && !this.extraManifests.stream().anyMatch(File::isFile)) return;
        Class<ApiFileGenerationMojo> clazz = ApiFileGenerationMojo.class;
        synchronized (ApiFileGenerationMojo.class) {
            if (!this.binaryLocations.exists()) {
                this.binaryLocations.mkdirs();
            }
            APIFileGenerator generator = new APIFileGenerator();
            generator.projectName = this.projectName;
            generator.projectLocation = this.projectLocation.getAbsolutePath();
            generator.binaryLocations = this.binaryLocations.getAbsolutePath();
            generator.targetFolder = this.targetFolder.getAbsolutePath();
            generator.allowNonApiProject = this.allowNonApiProject;
            generator.encoding = this.encoding;
            generator.debug = this.debug;
            generator.manifests = ApiFileGenerationMojo.join(this.extraManifests);
            if (this.addSourceFolders) {
                ArrayList<File> list = new ArrayList<File>(this.extraSourceLocations);
                for (Map.Entry entry : this.buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)this.project)).getJarToSourceFolderMap().entrySet()) {
                    for (String sourceFolder : (List)entry.getValue()) {
                        list.add(ApiFileGenerationMojo.canonicalFile(new File(this.project.getBasedir(), sourceFolder)));
                    }
                }
                generator.sourceLocations = ApiFileGenerationMojo.join(list);
            } else {
                generator.sourceLocations = ApiFileGenerationMojo.join(this.extraSourceLocations);
            }
            generator.generateAPIFile();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    private static String join(List<File> list) {
        return list.isEmpty() ? null : list.stream().map(File::toString).collect(Collectors.joining(File.pathSeparator));
    }
}

